/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.packager;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.common.io.CharStreams;
import com.google.common.io.OutputSupplier;
import com.xebialabs.deployit.packager.CiNameCache;
import com.xebialabs.deployit.packager.ManifestWriter;
import com.xebialabs.deployit.packager.truezip.TFiles;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Application;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Version;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.DatatypeConverter;

public class ManifestWriterDriver {
    public static final HashSet<String> APPLICATION_PROPERTIES_TO_SKIP = Sets.newHashSet((Object[])new String[]{"application"});
    public static final Set<String> ARTIFACT_PROPERTIES_TO_SKIP = Sets.newHashSet((Object[])new String[]{"placeholders"});
    private final CiNameCache cache;
    private ManifestWriter writer;

    public ManifestWriterDriver(CiNameCache cache, ManifestWriter writer) {
        this.writer = writer;
        this.cache = cache;
    }

    public void writeToPackage(Version version, TFile file) throws IOException {
        this.writeToPackage(version, file, false);
    }

    public void writeToPackage(Version version, TFile file, boolean writeFullAppPath) throws IOException {
        TFile manifestFile = new TFile((File)file, this.writer.getManifestFileName());
        this.write(version, writeFullAppPath);
        CharStreams.write((CharSequence)this.writer.toString(), (OutputSupplier)CharStreams.newWriterSupplier(TFiles.newOutputSupplier(manifestFile), (Charset)Charset.defaultCharset()));
    }

    @VisibleForTesting
    void write(Version version) {
        this.write(version, false);
    }

    @VisibleForTesting
    void write(Version version, boolean writeFullAppPath) {
        this.cache.scan(version);
        this.writeVersion(version, writeFullAppPath);
        this.writer.endManifest();
    }

    private void writeProperties(ConfigurationItem ci, WritePasswords writePasswords, ManifestWriter.ManifestCiWriter ciWriter) {
        for (PropertyDescriptor propertyDescriptor : ci.getType().getDescriptor().getPropertyDescriptors()) {
            this.writeProperty(propertyDescriptor, ci, writePasswords, ciWriter);
        }
    }

    private ManifestWriter.ManifestCiWriter writeVersion(Version version, boolean writeFullAppPath) {
        String appName = writeFullAppPath ? this.applicationNameWithDirectoryPathPreserved(version.getApplication()) : this.cache.lookup((ConfigurationItem)version.getApplication());
        ManifestWriter.ManifestCiWriter manifestCiWriter = this.writer.writeVersion(version.getType(), this.cache.lookup((ConfigurationItem)version), appName);
        WritePasswords exposePasswords = this.shouldWritePasswords(version);
        for (PropertyDescriptor pd : version.getType().getDescriptor().getPropertyDescriptors()) {
            if (APPLICATION_PROPERTIES_TO_SKIP.contains(pd.getName())) continue;
            this.writeProperty(pd, (ConfigurationItem)version, exposePasswords, manifestCiWriter);
        }
        return manifestCiWriter;
    }

    private WritePasswords shouldWritePasswords(Version version) {
        boolean exportAllPasswords = (Boolean)version.getProperty("exportAllPasswords");
        boolean exportOnlyPasswordPlaceholders = (Boolean)version.getProperty("exportOnlyPasswordPlaceholders");
        if (exportAllPasswords) {
            return WritePasswords.YES;
        }
        if (exportOnlyPasswordPlaceholders) {
            return WritePasswords.PLACEHOLDERS_ONLY;
        }
        return WritePasswords.NO;
    }

    private String applicationNameWithDirectoryPathPreserved(Application app) {
        if (app.getId().startsWith(Metadata.ConfigurationItemRoot.APPLICATIONS.getRootNodeName())) {
            return app.getId().substring(Metadata.ConfigurationItemRoot.APPLICATIONS.getRootNodeName().length() + 1);
        }
        return app.getId();
    }

    private String filterPasswordValue(String value, WritePasswords writePasswords) {
        if (writePasswords == WritePasswords.YES) {
            return value;
        }
        if (writePasswords == WritePasswords.PLACEHOLDERS_ONLY && value.startsWith("{{") && value.endsWith("}}")) {
            return value;
        }
        return "";
    }

    private void writeProperty(PropertyDescriptor pd, ConfigurationItem ci, WritePasswords writePasswords, ManifestWriter.ManifestCiWriter manifestCiWriter) {
        Object o = pd.get(ci);
        if (o == null) {
            return;
        }
        if (pd.isHidden()) {
            return;
        }
        if (ci.getType().instanceOf(Type.valueOf(Artifact.class)) && ARTIFACT_PROPERTIES_TO_SKIP.contains(pd.getName())) {
            return;
        }
        manifestCiWriter.property(pd.getName());
        switch (pd.getKind()) {
            case BOOLEAN: 
            case INTEGER: 
            case STRING: {
                String value = pd.get(ci).toString();
                if (pd.isPassword()) {
                    value = this.filterPasswordValue(value, writePasswords);
                }
                manifestCiWriter.writeAsStringValue(value);
                break;
            }
            case ENUM: {
                manifestCiWriter.writeAsStringValue(((Enum)pd.get(ci)).name());
                break;
            }
            case DATE: {
                Calendar c = Calendar.getInstance();
                c.setTime((Date)o);
                manifestCiWriter.writeAsStringValue(DatatypeConverter.printDateTime((Calendar)c));
                break;
            }
            case SET_OF_STRING: 
            case LIST_OF_STRING: {
                manifestCiWriter.writeStringCollectionProperty((List<String>)ImmutableList.copyOf((Collection)((Collection)o)));
                break;
            }
            case CI: {
                manifestCiWriter.writeCiReferenceProperty(this.cache.lookup((ConfigurationItem)o));
                break;
            }
            case SET_OF_CI: 
            case LIST_OF_CI: {
                if (pd.isAsContainment()) {
                    this.writeNestedConfigurationItems((Collection)o, writePasswords);
                    break;
                }
                manifestCiWriter.writeCiReferenceCollectionProperty((List<String>)ImmutableList.copyOf((Collection)Collections2.transform((Collection)((Collection)o), (Function)new Function<ConfigurationItem, String>(){

                    public String apply(ConfigurationItem input) {
                        return ManifestWriterDriver.this.cache.lookup(input);
                    }
                })));
                break;
            }
            case MAP_STRING_STRING: {
                manifestCiWriter.writeMapStringStringProperty((Map)o);
            }
        }
        manifestCiWriter.endProperty();
    }

    private void writeNestedConfigurationItems(Collection<ConfigurationItem> cis, WritePasswords writePasswords) {
        for (ConfigurationItem ci : cis) {
            ManifestWriter.ManifestCiWriter ciWriter = ci instanceof Artifact ? this.writer.writeCi(this.cache.lookup(ci), ci.getType(), CiNameCache.id(this.cache.lookup(ci), ((Artifact)ci).getFile().getName())) : this.writer.writeCi(this.cache.lookup(ci), ci.getType());
            this.writeProperties(ci, writePasswords, ciWriter);
            ciWriter.endCi();
        }
    }

    public String toString() {
        return this.writer.toString();
    }

    private static enum WritePasswords {
        YES,
        NO,
        PLACEHOLDERS_ONLY;

    }
}

