/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xldeploy.packager.io;

import com.typesafe.config.Config;
import com.xebialabs.deployit.util.TryWith$;
import com.xebialabs.xldeploy.packager.io.ArchiveStreamStreamer;
import com.xebialabs.xldeploy.packager.io.ArchiveStreamer;
import com.xebialabs.xldeploy.packager.io.ArtifactIOUtils$;
import com.xebialabs.xldeploy.packager.io.DirectoryStreamer;
import com.xebialabs.xldeploy.packager.io.EmptyStreamer;
import com.xebialabs.xldeploy.packager.io.FileStreamStreamer;
import com.xebialabs.xldeploy.packager.io.FileStreamer;
import com.xebialabs.xldeploy.packager.io.JarArchiveStreamStreamer;
import com.xebialabs.xldeploy.packager.io.JarFileArchiveStreamer;
import com.xebialabs.xldeploy.packager.io.Streamer;
import com.xebialabs.xldeploy.packager.io.StreamerFactory$;
import com.xebialabs.xldeploy.packager.io.SupportedArchiveExtensions$;
import com.xebialabs.xldeploy.packager.io.UnsupportedArchiveExtensionException;
import com.xebialabs.xldeploy.packager.io.ZipArchiveStreamStreamer;
import com.xebialabs.xldeploy.packager.io.ZipFileArchiveStreamer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ur!\u0002\n\u0014\u0011\u0003qb!\u0002\u0011\u0014\u0011\u0003\t\u0003\"\u0002\u0015\u0002\t\u0003I\u0003\u0002\u0003\u0016\u0002\u0005\u0004%\t!A\u0016\t\rQ\n\u0001\u0015!\u0003-\u0011\u0015)\u0014\u0001\"\u00017\u0011\u001d\t9#\u0001C\u0001\u0003S1A\u0001I\n\u0001q!A\u0011h\u0002B\u0001B\u0003%!\bC\u0003)\u000f\u0011\u0005\u0001\n\u0003\u0004K\u000f\u0001&Ia\u0013\u0005\u00071\u001e!\taE-\t\u000b\u0005<A\u0011\u00012\t\rM<\u0001\u0015\"\u0003u\u0011\u001d\tIa\u0002C\u0001\u0003\u0017Aq!!\u0006\b\t\u0003\t9\u0002C\u0004\u0002\u0016\u001d!\t!!\b\t\u0011\u0005\u0005r\u0001)C\u0005\u0003G\tqb\u0015;sK\u0006lWM\u001d$bGR|'/\u001f\u0006\u0003)U\t!![8\u000b\u0005Y9\u0012\u0001\u00039bG.\fw-\u001a:\u000b\u0005aI\u0012\u0001\u0003=mI\u0016\u0004Hn\\=\u000b\u0005iY\u0012!\u0003=fE&\fG.\u00192t\u0015\u0005a\u0012aA2p[\u000e\u0001\u0001CA\u0010\u0002\u001b\u0005\u0019\"aD*ue\u0016\fW.\u001a:GC\u000e$xN]=\u0014\u0005\u0005\u0011\u0003CA\u0012'\u001b\u0005!#\"A\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001d\"#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002=\u00051An\\4hKJ,\u0012\u0001\f\t\u0003[Ij\u0011A\f\u0006\u0003_A\nQa\u001d7gi)T\u0011!M\u0001\tOJL'P\u001f7fI&\u00111G\f\u0002\u0007\u0019><w-\u001a:\u0002\u000f1|wmZ3sA\u0005yA-\u001a4bk2$X*\u00199qS:<7\u000fF\u00018!\tyra\u0005\u0002\bE\u0005y\u0011M]2iSZ,W*\u00199qS:<7\u000f\u0005\u0003<\u0005\u0016+eB\u0001\u001fA!\tiD%D\u0001?\u0015\tyT$\u0001\u0004=e>|GOP\u0005\u0003\u0003\u0012\na\u0001\u0015:fI\u00164\u0017BA\"E\u0005\ri\u0015\r\u001d\u0006\u0003\u0003\u0012\u0002\"a\u000f$\n\u0005\u001d#%AB*ue&tw\r\u0006\u00028\u0013\")\u0011(\u0003a\u0001u\u00059r-\u001a;Be\u000eD\u0017N^3F]R\u0014\u0018p\u0015;sK\u0006lWM\u001d\u000b\u0003\u0019>\u0003\"aH'\n\u00059\u001b\"\u0001C*ue\u0016\fW.\u001a:\t\u000bAS\u0001\u0019A)\u0002\t\u0019LG.\u001a\t\u0003%Zk\u0011a\u0015\u0006\u0003)QS\u0011!V\u0001\u0005U\u00064\u0018-\u0003\u0002X'\n!a)\u001b7f\u0003u9W\r^!sG\"Lg/Z#oiJL8\u000b\u001e:fC6\u001cFO]3b[\u0016\u0014Hc\u0001'[?\")1l\u0003a\u00019\u0006\u0011\u0011n\u001d\t\u0003%vK!AX*\u0003\u0017%s\u0007/\u001e;TiJ,\u0017-\u001c\u0005\u0006A.\u0001\r!R\u0001\u0005]\u0006lW-\u0001\fhKR\f%o\u00195jm\u0016|U\u000f\u001e9viN#(/Z1n)\t\u0019\u0017\u000f\u0005\u0002e_6\tQM\u0003\u0002gO\u0006I\u0011M]2iSZ,'o\u001d\u0006\u0003Q&\f\u0001bY8naJ,7o\u001d\u0006\u0003U.\fqaY8n[>t7O\u0003\u0002m[\u00061\u0011\r]1dQ\u0016T\u0011A\\\u0001\u0004_J<\u0017B\u00019f\u0005M\t%o\u00195jm\u0016|U\u000f\u001e9viN#(/Z1n\u0011\u0015\u0011H\u00021\u0001R\u0003\u0019!\u0018M]4fi\u0006Ir-\u001a;UCJ\f%o\u00195jm\u0016|U\u000f\u001e9viN#(/Z1n)\r)8\u0010 \t\u0003mfl\u0011a\u001e\u0006\u0003q\u0016\f1\u0001^1s\u0013\tQxO\u0001\fUCJ\f%o\u00195jm\u0016|U\u000f\u001e9viN#(/Z1n\u0011\u0015\u0011X\u00021\u0001R\u0011\u0015iX\u00021\u0001\u007f\u0003)\u0019w.\u001c9sKN\u001cxN\u001d\t\u0007G}\f\u0019!a\u0001\n\u0007\u0005\u0005AEA\u0005Gk:\u001cG/[8ocA\u0019!+!\u0002\n\u0007\u0005\u001d1K\u0001\u0007PkR\u0004X\u000f^*ue\u0016\fW.A\niCN\f%o\u00195jm\u0016,\u0005\u0010^3og&|g\u000e\u0006\u0003\u0002\u000e\u0005M\u0001cA\u0012\u0002\u0010%\u0019\u0011\u0011\u0003\u0013\u0003\u000f\t{w\u000e\\3b]\")\u0001M\u0004a\u0001\u000b\u0006A1\u000f\u001e:fC6,'\u000fF\u0003M\u00033\tY\u0002C\u0003\\\u001f\u0001\u0007A\fC\u0003a\u001f\u0001\u0007Q\tF\u0002M\u0003?AQ\u0001\u0015\tA\u0002E\u000babZ3u\u0003J\u001c\u0007.\u001b<f)f\u0004X\rF\u0002F\u0003KAQ\u0001Y\tA\u0002\u0015\u000b\u0011BZ8s\u0007>tg-[4\u0015\u0007]\nY\u0003C\u0004\u0002.\u0019\u0001\r!a\f\u0002\r\r|gNZ5h!\u0011\t\t$!\u000f\u000e\u0005\u0005M\"\u0002BA\u0017\u0003kQ1!a\u000e\u001c\u0003!!\u0018\u0010]3tC\u001a,\u0017\u0002BA\u001e\u0003g\u0011aaQ8oM&<\u0007")
public class StreamerFactory {
    private final Map<String, String> archiveMappings;

    public static StreamerFactory forConfig(Config config) {
        return StreamerFactory$.MODULE$.forConfig(config);
    }

    public static StreamerFactory defaultMappings() {
        return StreamerFactory$.MODULE$.defaultMappings();
    }

    private Streamer getArchiveEntryStreamer(File file) {
        Streamer streamer;
        String mappedExt = this.getArchiveType(file.getName());
        boolean extOK = BoxesRunTime.unboxToBoolean((Object)TryWith$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> ArtifactIOUtils$.MODULE$.getResettableInputStream(new FileInputStream(file)), (Function1 & Serializable & scala.Serializable)resettableIs -> BoxesRunTime.boxToBoolean((boolean)SupportedArchiveExtensions$.MODULE$.archiveTypeMatchesExtension(resettableIs, mappedExt, file.getName()))).get());
        String string = mappedExt;
        if (!extOK) {
            streamer = new EmptyStreamer();
        } else {
            String string2 = SupportedArchiveExtensions$.MODULE$.ZIP();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                streamer = new ZipFileArchiveStreamer(file);
            } else {
                String string4 = SupportedArchiveExtensions$.MODULE$.JAR();
                String string5 = string;
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    streamer = new JarFileArchiveStreamer(file);
                } else {
                    String string6 = SupportedArchiveExtensions$.MODULE$.TAR();
                    String string7 = string;
                    if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                        streamer = new ArchiveStreamer(file, (Function1<InputStream, InputStream>)(Function1 & Serializable & scala.Serializable)is -> is);
                    } else {
                        String string8 = SupportedArchiveExtensions$.MODULE$.TARGZ();
                        String string9 = string;
                        if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                            streamer = new ArchiveStreamer(file, (Function1<InputStream, InputStream>)(Function1 & Serializable & scala.Serializable)is -> new GzipCompressorInputStream(is));
                        } else {
                            String string10 = SupportedArchiveExtensions$.MODULE$.TARBZ2();
                            String string11 = string;
                            if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                                streamer = new ArchiveStreamer(file, (Function1<InputStream, InputStream>)(Function1 & Serializable & scala.Serializable)is -> new BZip2CompressorInputStream(is));
                            } else {
                                throw new MatchError((Object)string);
                            }
                        }
                    }
                }
            }
        }
        return streamer;
    }

    public Streamer getArchiveEntryStreamStreamer(InputStream is2, String name) {
        Streamer streamer;
        String mappedExt = this.getArchiveType(name);
        InputStream resettableIs = ArtifactIOUtils$.MODULE$.getResettableInputStream(is2);
        boolean extOK = SupportedArchiveExtensions$.MODULE$.archiveTypeMatchesExtension(resettableIs, mappedExt, name);
        String string = mappedExt;
        if (!extOK) {
            streamer = new EmptyStreamer();
        } else {
            String string2 = SupportedArchiveExtensions$.MODULE$.ZIP();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                streamer = new ZipArchiveStreamStreamer(resettableIs);
            } else {
                String string4 = SupportedArchiveExtensions$.MODULE$.JAR();
                String string5 = string;
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    streamer = new JarArchiveStreamStreamer(resettableIs);
                } else {
                    String string6 = SupportedArchiveExtensions$.MODULE$.TAR();
                    String string7 = string;
                    if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                        streamer = new ArchiveStreamStreamer(resettableIs, (Function1<InputStream, InputStream>)(Function1 & Serializable & scala.Serializable)is -> is);
                    } else {
                        String string8 = SupportedArchiveExtensions$.MODULE$.TARGZ();
                        String string9 = string;
                        if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                            streamer = new ArchiveStreamStreamer(resettableIs, (Function1<InputStream, InputStream>)(Function1 & Serializable & scala.Serializable)is -> new GzipCompressorInputStream(is));
                        } else {
                            String string10 = SupportedArchiveExtensions$.MODULE$.TARBZ2();
                            String string11 = string;
                            if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                                streamer = new ArchiveStreamStreamer(resettableIs, (Function1<InputStream, InputStream>)(Function1 & Serializable & scala.Serializable)is -> new BZip2CompressorInputStream(is));
                            } else {
                                throw new MatchError((Object)string);
                            }
                        }
                    }
                }
            }
        }
        return streamer;
    }

    public ArchiveOutputStream getArchiveOutputStream(File target) {
        ZipArchiveOutputStream zipArchiveOutputStream;
        String string = this.getArchiveType(target.getName());
        String string2 = SupportedArchiveExtensions$.MODULE$.ZIP();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            zipArchiveOutputStream = new ZipArchiveOutputStream(target);
        } else {
            String string4 = SupportedArchiveExtensions$.MODULE$.JAR();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                zipArchiveOutputStream = new ZipArchiveOutputStream(target);
            } else {
                String string6 = SupportedArchiveExtensions$.MODULE$.TAR();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    zipArchiveOutputStream = this.getTarArchiveOutputStream(target, (Function1<OutputStream, OutputStream>)(Function1 & Serializable & scala.Serializable)os -> os);
                } else {
                    String string8 = SupportedArchiveExtensions$.MODULE$.TARGZ();
                    String string9 = string;
                    if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                        zipArchiveOutputStream = this.getTarArchiveOutputStream(target, (Function1<OutputStream, OutputStream>)(Function1 & Serializable & scala.Serializable)os -> new GzipCompressorOutputStream(os));
                    } else {
                        String string10 = SupportedArchiveExtensions$.MODULE$.TARBZ2();
                        String string11 = string;
                        if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                            zipArchiveOutputStream = this.getTarArchiveOutputStream(target, (Function1<OutputStream, OutputStream>)(Function1 & Serializable & scala.Serializable)os -> new BZip2CompressorOutputStream(os));
                        } else {
                            String originExt = (String)((Tuple2)this.archiveMappings.find((Function1 & Serializable & scala.Serializable)am -> BoxesRunTime.boxToBoolean((boolean)StreamerFactory.$anonfun$getArchiveOutputStream$4(target, am))).get())._1();
                            throw new UnsupportedArchiveExtensionException(new StringBuilder(59).append(target.getName()).append(" with extension ").append(originExt).append(" -> ").append(string).append(" is not a supported archive output type").toString());
                        }
                    }
                }
            }
        }
        return zipArchiveOutputStream;
    }

    private TarArchiveOutputStream getTarArchiveOutputStream(File target, Function1<OutputStream, OutputStream> compressor) {
        OutputStream wrapped = (OutputStream)compressor.apply((Object)new FileOutputStream(target));
        TarArchiveOutputStream os = new TarArchiveOutputStream(wrapped);
        os.setLongFileMode(3);
        os.setBigNumberMode(2);
        return os;
    }

    public boolean hasArchiveExtension(String name) {
        return this.archiveMappings.exists((Function1 & Serializable & scala.Serializable)am -> BoxesRunTime.boxToBoolean((boolean)name.endsWith(new StringBuilder(11).append('.').append((String)am._1()).toString())));
    }

    public Streamer streamer(InputStream is, String name) {
        return this.hasArchiveExtension(name) ? this.getArchiveEntryStreamStreamer(is, name) : new FileStreamStreamer(is, name);
    }

    public Streamer streamer(File file) {
        return file.isDirectory() ? new DirectoryStreamer(file) : (this.hasArchiveExtension(file.getName()) ? this.getArchiveEntryStreamer(file) : new FileStreamer(file));
    }

    private String getArchiveType(String name) {
        Some some;
        Tuple2 tuple2;
        Option option = this.archiveMappings.find((Function1 & Serializable & scala.Serializable)am -> BoxesRunTime.boxToBoolean((boolean)name.endsWith(new StringBuilder(11).append('.').append((String)am._1()).toString())));
        if (None$.MODULE$.equals(option)) {
            throw new UnsupportedArchiveExtensionException(new StringBuilder(27).append(name).append(" is not a supported archive").toString());
        }
        if (!(option instanceof Some) || (tuple2 = (Tuple2)(some = (Some)option).value()) == null) {
            throw new MatchError((Object)option);
        }
        String originExt = (String)tuple2._1();
        String mappedExt = (String)tuple2._2();
        StreamerFactory$.MODULE$.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Detected mapped archive extension ").append(originExt).append(" -> ").append(mappedExt).append(" for ").append(name).toString());
        String string = mappedExt;
        return string;
    }

    public static final /* synthetic */ boolean $anonfun$getArchiveOutputStream$4(File target$1, Tuple2 am) {
        return target$1.getName().endsWith(new StringBuilder(11).append('.').append((String)am._1()).toString());
    }

    public StreamerFactory(Map<String, String> archiveMappings) {
        this.archiveMappings = archiveMappings;
    }
}

