package com.xebialabs.deployit.engine.tasker

import akka.actor.{ActorRef, Actor, Props}
import com.xebialabs.deployit.engine.tasker.ArchiveActor.messages.SendToArchive
import com.xebialabs.deployit.engine.tasker.messages.{FailedToArchive, Archived}
import scala.util.{Failure, Success, Try}
import grizzled.slf4j.Logging

object ArchiveActor {
  val name = "archive"
  def props(service: Archive) = Props(classOf[ArchiveActor], service)

  object messages {
    case class SendToArchive(task: Task, notificationActor: ActorRef)
  }

}

class ArchiveActor(service: Archive) extends Actor with Logging {

  def receive: Actor.Receive = ReceiveWithMdc() {
    case SendToArchive(task, notificationActor: ActorRef) =>
      info(s"Received [Archive] message with task [${task.getId}].")
      Try(service.archive(task)) match {
        case Success(unit) => notificationActor ! Archived(task.getId)
        case Failure(ex) => notificationActor ! FailedToArchive(task.getId, ex)
      }
    case m@_ => error(s"I don't understand message [$m]")
  }
}
