package com.xebialabs.deployit.deployment.planner;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;

import com.xebialabs.deployit.engine.spi.execution.ExecutionStateListener;

public class SerialPlan extends CompositePlan {

    public SerialPlan(List<? extends Plan> subPlans, List<ExecutionStateListener> listeners) {
        super(subPlans, listeners);
    }

    @Override
    public Writer writePlan(final Writer writer) {
        PrintWriter out = new PrintWriter(writer);

        boolean first = true;

        for (Plan subPlan : getSubPlans()) {
            StringWriter singlePlanWriter = new StringWriter();
            if (!first) {
                singlePlanWriter.append("-------------------------------------------->\n");
            }
            subPlan.writePlan(singlePlanWriter);
            out.append(indent(singlePlanWriter.toString(), 4));

            first = false;
        }

        return writer;
    }

}
