package com.xebialabs.deployit.deployment.rules;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

import com.google.common.annotations.VisibleForTesting;

import com.xebialabs.deployit.plugin.api.flow.Step;

import static com.google.common.collect.Maps.newHashMap;
import static java.lang.String.format;

public class RuleStore {

    private static final AtomicReference<RuleStore> INSTANCE = new AtomicReference<RuleStore>(new RuleStore());

    public static RuleStore getInstance() {
        return INSTANCE.get();
    }

    private final Map<String, Class<? extends Step>> stepClassesByElement = newHashMap();

    private final Map<String, Class<? extends Step>> stepClassesByFunction = newHashMap();

    private final Map<String, Rule> rules = newHashMap();

    public void registerStepClass(Class<? extends Step> stepClass, StepMetadata stepMetadata) {
        if (stepClassesByElement.containsKey(stepMetadata.elementName())) {
            throw new IllegalArgumentException(format("Builder with duplicate element name [%s] found.", stepMetadata.elementName()));
        }
        if (stepClassesByFunction.containsKey(stepMetadata.functionName())) {
            throw new IllegalArgumentException(format("Builder with duplicate function name [%s] found.", stepMetadata.functionName()));
        }
        stepClassesByElement.put(stepMetadata.elementName(), stepClass);
        stepClassesByFunction.put(stepMetadata.functionName(), stepClass);
    }

    public void registerRule(Rule rule) {
        if (rules.containsKey(rule.getName())) {
            throw new IllegalArgumentException(format("Rule with duplicate name [%s] found.", rule.getName()));
        }
        rules.put(rule.getName(), rule);
    }

    public Collection<Rule> getRules() {
        return rules.values();
    }

    public Rule getRule(String ruleName) {
        return rules.get(ruleName);
    }

    public Collection<Class<? extends Step>> getStepClasses() {
        return stepClassesByElement.values();
    }

    public Class<? extends Step> getStepClassByElement(String elementName) {
        return stepClassesByElement.get(elementName);
    }

    public Class<? extends Step> getStepClassByFunction(String functionName) {
        return stepClassesByFunction.get(functionName);
    }

}
