package com.xebialabs.deployit.deployment.rules;

import javax.script.*;

import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.udm.Deployed;

import static javax.script.ScriptContext.ENGINE_SCOPE;

public class ScriptRule extends Rule {

    private String script;

    public ScriptRule(String name, Scope scope) {
        super(name, scope);
    }

    @Override
    public void fire(Object scopedObject, DeploymentPlanningContext context) {
        final ScriptEngineManager engineManager = new ScriptEngineManager();
        final ScriptEngine jythonEngine = engineManager.getEngineByName("python");

        if (jythonEngine == null) {
            throw new IllegalStateException("Could not find the JythonEngine, is it on the classpath?");
        }

        try {
            ScriptContext scriptContext = buildContext(scopedObject, context);
            jythonEngine.eval(script, scriptContext);
        } catch (ScriptException e) {
            throw new IllegalStateException("Script failed", e);
        }
    }

    private ScriptContext buildContext(Object scopedObject, DeploymentPlanningContext context) {
        SimpleScriptContext scriptContext = new SimpleScriptContext();
        if (scope == Scope.DEPLOYED) {
            scriptContext.setAttribute("delta", scopedObject, ENGINE_SCOPE);
            scriptContext.setAttribute("deployed", getDeployed((Delta) scopedObject), ENGINE_SCOPE);
        } else if (scope == Scope.PLAN) {
            scriptContext.setAttribute("deltas", scopedObject, ENGINE_SCOPE);
        } else if (scope == Scope.PRE_PLAN || scope == Scope.POST_PLAN) {
            scriptContext.setAttribute("specification", scopedObject, ENGINE_SCOPE);
        }
        scriptContext.setAttribute("deployedApplication", context.getDeployedApplication(), ENGINE_SCOPE);
        scriptContext.setAttribute("repository", context.getRepository(), ENGINE_SCOPE);
        scriptContext.setAttribute("context", context, ENGINE_SCOPE);
        return scriptContext;
    }

    private Deployed getDeployed(Delta delta) {
        if (delta.getOperation() == Operation.DESTROY) {
            return delta.getPrevious();
        }
        return delta.getDeployed();
    }

    public void setScript(String script) {
        this.script = script;
    }

    public String getScript() {
        return script;
    }
}
