package com.xebialabs.deployit.deployment.planner

import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification
import com.xebialabs.deployit.plugin.api.services.Repository

import collection.convert.wrapAll._
import scala.collection.mutable
import com.xebialabs.deployit.deployment.planner.StepPlan.{StepWithDelta}

class SizeChunkingPlanner (wrappedPlanner: Planner) extends Planner with ChunkingPlannerBase {

  val threshold: Int = 100

  def plan(spec: DeltaSpecification, repository: Repository): Plan = {
    val complexPlan: Plan = wrappedPlanner.plan(spec, repository)
    chunkBySize(complexPlan)
  }

  def chunkBySize(plan: Plan): Plan = plan match {
    case pp: ParallelPlan => new ParallelPlan(pp.getDescription, pp.getSubPlans.map(chunkBySize), pp.getListeners)
    case sp: SerialPlan => new SerialPlan(sp.getDescription, sp.getSubPlans.map(chunkBySize), sp.getListeners)
    case stp: StepPlan if stp.getSteps.size() > threshold => new SerialPlan(stp.getDescription, chunkBySize(stp), stp.getListeners)
    case stp: StepPlan => stp
  }

  def chunkBySize(plan: StepPlan): List[StepPlan] = {
    plan.getStepsWithDelta
      .grouped(threshold)
      .zipWithIndex
      .map(createStepPlanForSizedChunks(_, plan)).toList
  }

  def createStepPlanForSizedChunks(b : (mutable.Buffer[StepWithDelta], Int), plan: StepPlan): StepPlan = {
    def label(i: Int, p: StepPlan): String = s"Step ${1 + threshold * i} to ${Math.min(threshold * (i + 1), p.getStepsWithDelta.size())}"
    b match {
    case (steps, i) => new StepPlan(label(i, plan),
                                    steps,
                                    findCheckpoints(steps, plan.getCheckpoints.toList),
                                    plan.getListeners)
    }
  }

}
