/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.deployment.orchestrator;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.api.udm.Version;
import java.util.Map;

public class DescriptionHelper {
    private static Map verbs = ImmutableMap.of((Object)Operation.CREATE, (Object)"Deploying", (Object)Operation.DESTROY, (Object)"Undeploying", (Object)Operation.MODIFY, (Object)"Updating", (Object)Operation.NOOP, (Object)"Not updating");
    private static Joiner joinWithSpaces = Joiner.on((String)" ");

    public static String getDescriptionForSpec(DeltaSpecification specification) {
        DeployedApplication deployedApplication = specification.getDeployedApplication();
        return joinWithSpaces.join(verbs.get(specification.getOperation()), (Object)deployedApplication.getName(), new Object[]{deployedApplication.getVersion().getName(), "on environment", deployedApplication.getEnvironment().getName()});
    }

    public static String getDescriptionForContainer(Operation op, Container con) {
        return joinWithSpaces.join(verbs.get(op), (Object)"on container", new Object[]{con.getName()});
    }

    public static String getDescriptionForPackage(Operation op, Version version) {
        return joinWithSpaces.join(verbs.get(op), (Object)"package", new Object[]{version.getApplication().getName(), version.getName()});
    }
}

