package com.xebialabs.deployit.deployment.rules

import java.lang.reflect.{InvocationTargetException, Modifier, Method}
import com.xebialabs.deployit.plugin.api.Deprecations._
import com.xebialabs.deployit.booter.local.utils.ReflectionUtils._
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext
import com.xebialabs.deployit.deployment.planner.DeploymentPlanner

object JavaContributorInvokerRule {
  def buildName(contributor: Method) = s"${contributor.getDeclaringClass.getName}.${contributor.getName}"
}

import JavaContributorInvokerRule._

class JavaContributorInvokerRule(contributor: Method) extends CanFireRule(buildName(contributor), Scope.PLAN) {

  override def canFire(deltas: AnyRef, context: DeploymentPlanningContext): Boolean = deltas.isInstanceOf[Deltas]

  override def doFire(deltas: AnyRef, context: DeploymentPlanningContext) {
    try {
      if (Modifier.isStatic(contributor.getModifiers)) {
        contributor.invoke(null, deltas, context)
      } else {
        deprecated("Non-static contributors are considered deprecated, consider making [%s] static", contributor)
        val contributorInstance: Any = contributor.getDeclaringClass.newInstance
        contributor.invoke(contributorInstance, deltas, context)
      }
    } catch {
      case e: InstantiationException => throw new DeploymentPlanner.PlannerException(e)
      case e: IllegalAccessException =>throw new DeploymentPlanner.PlannerException(e)
      case e: InvocationTargetException => throw handleInvocationTargetException(e, "")
    }
  }
}
