package com.xebialabs.deployit.deployment.rules
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext
import com.xebialabs.deployit.plugin.api.deployment.specification.{Operation, Delta}
import com.xebialabs.deployit.plugin.api.udm.Deployed
import javax.script.ScriptContext._
import javax.script._

class ScriptRule(name: String, scope: Scope, script: String) extends Rule(name, scope) {

  def fire(scopedObject: AnyRef, context: DeploymentPlanningContext) {
    val engineManager: ScriptEngineManager = new ScriptEngineManager
    val jythonEngine: ScriptEngine = engineManager.getEngineByName("python")

    if (jythonEngine == null) {
      throw new IllegalStateException("Could not find the JythonEngine, is it on the classpath?")
    }

    try {
      val scriptContext: ScriptContext = buildContext(scopedObject, context)
      jythonEngine.eval(script, scriptContext)
    } catch {
      case e: ScriptException =>
        throw new IllegalStateException("Script failed", e)
    }
  }

  private def buildContext(scopedObject: AnyRef, context: DeploymentPlanningContext): ScriptContext = {
    val scriptContext: SimpleScriptContext = new SimpleScriptContext
    scope match {
      case Scope.DEPLOYED =>
        scriptContext.setAttribute("delta", scopedObject, ENGINE_SCOPE)
        scriptContext.setAttribute("deployed", getDeployed(scopedObject.asInstanceOf[Delta]), ENGINE_SCOPE)
      case Scope.PLAN =>
        scriptContext.setAttribute("deltas", scopedObject, ENGINE_SCOPE)
      case Scope.PRE_PLAN | Scope.POST_PLAN =>
        scriptContext.setAttribute("specification", scopedObject, ENGINE_SCOPE)
    }

    scriptContext.setAttribute("deployedApplication", context.getDeployedApplication, ENGINE_SCOPE)
    scriptContext.setAttribute("repository", context.getRepository, ENGINE_SCOPE)
    scriptContext.setAttribute("context", context, ENGINE_SCOPE)
    scriptContext
  }

  private def getDeployed(delta: Delta): Deployed[_, _] = {
    if (delta.getOperation == Operation.DESTROY) delta.getPrevious else delta.getDeployed
  }

  def getScript: String = script
}
