package com.xebialabs.deployit.deployment.rules

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.deployit.plugin.api.deployment.specification.{Delta, Operation}
import java.lang.reflect.{InvocationTargetException, Method}
import com.xebialabs.deployit.plugin.api.rules.Scope
import com.xebialabs.deployit.plugin.api.udm.Deployed
import com.xebialabs.deployit.booter.local.utils.ReflectionUtils._

object JavaDeployedInvokerRule {
  private def buildName(deployedType: Type, typeContributor: Method, operation: Operation) = s"$deployedType.${typeContributor.getName}_$operation"
}

import JavaDeployedInvokerRule._

class JavaDeployedInvokerRule(deployedType: Type, typeContributor: Method, operation: Operation) extends Rule(buildName(deployedType, typeContributor, operation), Scope.DEPLOYED) {

  override def canFire(delta: AnyRef, context: RulePlanningContext): Boolean = {
    delta.isInstanceOf[Delta] && {
      val d = delta.asInstanceOf[Delta]
      d.getOperation == operation && getDeployed(d).getType.instanceOf(deployedType)
    }
  }

  override def doFire(delta: AnyRef, context: RulePlanningContext){
    val deployed: Deployed[_, _] = getDeployed(delta.asInstanceOf[Delta])
    debug(s"Invoking rule [$getName] for deployed [$deployed]")
    try {
      if (typeContributor.getParameterTypes.length == 2) {
        typeContributor.invoke(deployed, context, delta)
      } else {
        typeContributor.invoke(deployed, context)
      }
    } catch {
      case e: InvocationTargetException => throw handleInvocationTargetException(e, "")
      case e: Exception => throw e
    }
  }

  private def getDeployed(delta: Delta): Deployed[_, _] = if (delta.getOperation == Operation.DESTROY) delta.getPrevious else delta.getDeployed
}
