package com.xebialabs.deployit.deployment

import com.xebialabs.platform.script.jython.ScriptSource

package object rules {

  final private[rules] val rulesXmlFileName = "xl-rules.xml"

  final private[rules] val rulesXsdLocation = "com/xebialabs/deployit/deployment/rules/xl-rules.xsd"

  final private[rules] val ruleLib = ScriptSource.byResource("com/xebialabs/deployit/deployment/rules/script_rule_lib.py")

  def getClassChain(c: Class[_]): Seq[Class[_]] = c +: Option(c.getSuperclass).map(getClassChain).getOrElse(Seq())
}
