package com.xebialabs.deployit.deployment.orchestrator

import com.xebialabs.deployit.engine.spi.orchestration._
import com.xebialabs.deployit.plugin.api.deployment.specification.{Operation, DeltaSpecification}
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication

import com.xebialabs.deployit.engine.spi.orchestration.Orchestrations._

import collection.convert.wrapAll._
import com.xebialabs.deployit.deployment.planner.DefaultDeltaSpecification

class OrchestratorComposer {

  def orchestrate(o: java.util.List[Orchestrator], spec: DeltaSpecification): Orchestration = {
    if (o.isEmpty) {
      new DefaultOrchestrator().orchestrate(spec)
    }
    else o.tail.foldRight(o.toList.head.orchestrate(spec)){ case (or, on) =>
         applyOrchestrator(on, or, spec.getOperation, spec.getPreviousDeployedApplication, spec.getDeployedApplication)}
  }

  def applyOrchestrator(orchestration: Orchestration, orchestrator:Orchestrator, op:Operation, prev:DeployedApplication, depl:DeployedApplication): Orchestration = orchestration match {
    case s: SerialOrchestration => serial(s.getDescription, s.getPlans.map(applyOrchestrator(_, orchestrator, op, prev, depl)))
    case p: ParallelOrchestration => parallel(p.getDescription, p.getPlans.map(applyOrchestrator(_, orchestrator, op, prev, depl)))
    case i: InterleavedOrchestration =>
      orchestrator.orchestrate(new DefaultDeltaSpecification(op, prev, depl, i.getDeltas)) match {
        case s: SerialOrchestration => serial(i.getDescription, s.getPlans)
        case p: ParallelOrchestration => parallel(i.getDescription, p.getPlans)
        case i2: InterleavedOrchestration => interleaved(i.getDescription, i2.getDeltas)
      }
  }
}
