package com.xebialabs.deployit.deployment.planner

import java.util.{ArrayList => juArrayList, List => juList}

import com.xebialabs.deployit.deployment.planner.StepPlan.{Checkpoint, StepWithPlanningInfo}
import com.xebialabs.deployit.engine.spi.execution.ExecutionStateListener
import com.xebialabs.xlplatform.satellite.Satellite

import scala.collection.mutable

trait PlanSugar {

  def findCheckpoints(chunk: mutable.Buffer[StepWithPlanningInfo], cp: juList[StepPlan.Checkpoint]): juList[Checkpoint] = {
    import scala.collection.convert.wrapAll._
    val chunkDeltas = chunk.flatMap(_.getDeltas)
    cp.filter(x => chunkDeltas.contains(x.getDelta))
  }

}

object PlanSugar {

  implicit class CompositePlanCopySugar(val plan: CompositePlan) extends AnyVal {

    def copy(description: String = plan.getDescription,
             subPlans: juList[_ <: ExecutablePlan] = plan.getSubPlans,
             listeners: juList[ExecutionStateListener] = plan.getListeners,
             satellite: Satellite = plan.satellite) = {
      plan match {
        case sp: SerialPlan => new SerialPlan(description, subPlans, listeners, satellite)
        case pp: ParallelPlan => new ParallelPlan(description, subPlans, listeners, satellite)
        case _ => throw new IllegalArgumentException(s"Unknown composite plan subtype $plan")
      }

    }
  }

  implicit class PlanPhaseCopySugar(val phase: PlanPhase) extends AnyVal {

    def copy(description: String = phase.getDescription,
             plan: ExecutablePlan = phase.plan,
             listeners: juList[ExecutionStateListener] = phase.getListeners) = {
      new PlanPhase(plan, description, listeners, phase.alwaysExecuted)

    }
  }

  implicit class PhasedPlanCopySugar(val phasedPlan: PhasedPlan) extends AnyVal {

    def copy(phases: juList[PlanPhase] = phasedPlan.phases,
             listeners: juList[ExecutionStateListener] = phasedPlan.getListeners) = {
      new PhasedPlan(phases, listeners)

    }
  }

  implicit class ExecutableSugar(val plan: ExecutablePlan) extends AnyVal {

    def toSerial(description: String = plan.getDescription,
                 subPlans: juList[ExecutablePlan],
                 listeners: juList[ExecutionStateListener] = plan.getListeners,
                 satellite: Satellite = plan.satellite) =
      new SerialPlan(description, subPlans, listeners, satellite)

    def emptySteps() = new StepPlan(plan.getDescription, new juArrayList[StepWithPlanningInfo](), new juArrayList[Checkpoint](), plan.getListeners, plan.satellite)

  }

  implicit class StepPlanSugar(val sp: StepPlan) extends AnyVal {
    def copy(description: String = sp.getDescription,
             steps: juList[StepWithPlanningInfo] = sp.getStepsWithPlanningInfo,
             checkpoints: juList[Checkpoint] = sp.getCheckpoints,
             listeners: juList[ExecutionStateListener] = sp.getListeners,
             satellite: Satellite = sp.satellite) = {
      new StepPlan(description, steps, checkpoints, listeners, satellite)

    }
  }

}