package com.xebialabs.deployit.deployment.planner;

import static com.google.common.collect.Lists.newArrayList;

import java.util.List;

import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.xld.AppliedDistribution;

public class DeltaSpecificationBuilder {

    private Operation operation = Operation.CREATE;
    private List<Delta> deltas = newArrayList();
    private AppliedDistribution previousDeployedApplication;
    private AppliedDistribution deployedApplication;
    private final boolean rollback;

    public DeltaSpecificationBuilder(boolean rollback) {
        this.rollback = rollback;
    }

    public DeltaSpecificationBuilder() {
        this(false);
    }

    public static DeltaSpecificationBuilder newSpecification() {
        return new DeltaSpecificationBuilder(false);
    }

    public static DeltaSpecificationBuilder newRollbackSpecification() {
        return new DeltaSpecificationBuilder(true);
    }

    @SuppressWarnings("rawtypes")
    public DeltaSpecificationBuilder create(Deployed d) {
        return with(Operation.CREATE, null, d);
    }

    @SuppressWarnings("rawtypes")
    public DeltaSpecificationBuilder modify(Deployed previous, Deployed d) {
        return with(Operation.MODIFY, previous, d);
    }

    @SuppressWarnings("rawtypes")
    public DeltaSpecificationBuilder destroy(Deployed d) {
        return with(Operation.DESTROY, d, null);
    }

    @SuppressWarnings("rawtypes")
    public DeltaSpecificationBuilder noOp(Deployed d) {
        return with(Operation.NOOP, d, d);
    }

    @SuppressWarnings("rawtypes")
    private DeltaSpecificationBuilder with(Operation operation, Deployed previous, Deployed deployed) {
        deltas.add(new DefaultDelta(operation, previous, deployed));
        return this;
    }

    public DeltaSpecificationBuilder with(Delta delta) {
        deltas.add(delta);
        return this;
    }

    public DeltaSpecificationBuilder upgrade(AppliedDistribution previous, AppliedDistribution deployment) {
        this.previousDeployedApplication = previous;
        this.deployedApplication = deployment;
        this.operation = Operation.MODIFY;
        return this;
    }

    public DeltaSpecificationBuilder undeploy(AppliedDistribution deployment) {
	    this.previousDeployedApplication = deployment;
        this.deployedApplication = deployment;
        this.operation = Operation.DESTROY;
        return this;
    }

    public DeltaSpecificationBuilder initial(AppliedDistribution deployment) {
        this.deployedApplication = deployment;
        this.operation = Operation.CREATE;
        return this;
    }

    public DeltaSpecification build() {
        return new DefaultDeltaSpecification(operation, previousDeployedApplication, deployedApplication, deltas, rollback);
    }
}
