package com.xebialabs.deployit.deployment.orchestrator

import com.xebialabs.deployit.deployment.planner.DefaultDeltaSpecification
import com.xebialabs.deployit.engine.spi.orchestration.Orchestrations._
import com.xebialabs.deployit.engine.spi.orchestration._
import com.xebialabs.deployit.plugin.api.deployment.specification.{DeltaSpecification, Operation}
import com.xebialabs.deployit.plugin.api.xld.AppliedDistribution

import scala.collection.convert.wrapAll._

class OrchestratorComposer {

  def orchestrate(o: java.util.List[Orchestrator], spec: DeltaSpecification): Orchestration = {
    val orchestartors: Seq[Orchestrator] = o.toList
    orchestartors match {
      case Nil =>
        new DefaultOrchestrator().orchestrate(spec)
      case head :: tail =>
        tail.foldLeft(head.orchestrate(spec)) { case (previousResult, orchestrator) =>
          applyOrchestrator(previousResult, orchestrator, spec.getOperation, spec.getPreviousAppliedDistribution, spec.getAppliedDistribution)
        }
    }
  }

  private def applyOrchestrator(orchestration: Orchestration, orchestrator: Orchestrator, op: Operation, prev: AppliedDistribution, depl: AppliedDistribution): Orchestration = orchestration match {
    case s: SerialOrchestration => serial(s.getDescription, s.getPlans.map(applyOrchestrator(_, orchestrator, op, prev, depl)))
    case p: ParallelOrchestration => parallel(p.getDescription, p.getPlans.map(applyOrchestrator(_, orchestrator, op, prev, depl)))
    case i: InterleavedOrchestration =>
      orchestrator.orchestrate(new DefaultDeltaSpecification(op, prev, depl, i.getDeltas)) match {
        case s: SerialOrchestration => serial(i.getDescription, s.getPlans)
        case p: ParallelOrchestration => parallel(i.getDescription, p.getPlans)
        case i2: InterleavedOrchestration => interleaved(i.getDescription, i2.getDeltas)
      }
  }
}
