package com.xebialabs.deployit.deployment.planner

import com.xebialabs.deployit.deployment.ChangeSetBuilder.determineChanges
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification
import com.xebialabs.deployit.plugin.api.flow.{ExecutionContext, Step, StepExitCode}
import com.xebialabs.deployit.repository.RepositoryServiceHolder

import scala.beans.BeanProperty

class RepositoryUpdateStep(@BeanProperty val order: Int = 100,
                           @BeanProperty val description: String = "Update the repository with deployment.",
                           @BeanProperty val spec: DeltaSpecification) extends Step {

  override def execute(ctx: ExecutionContext): StepExitCode = {
    ctx.logOutput("Starting repository update.")
    RepositoryServiceHolder.getRepositoryService.execute(determineChanges(spec))
    ctx.logOutput("Finished repository update.")
    StepExitCode.SUCCESS
  }

}