/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.deployment.planner;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.api.xld.AppliedDistribution;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class DefaultDeltaSpecification
implements DeltaSpecification,
Serializable {
    private boolean rollback;
    private Operation operation;
    private AppliedDistribution previousDeployedApplication;
    private AppliedDistribution deployedApplication;
    private List<Delta> deltas;

    public DefaultDeltaSpecification(Operation operation, AppliedDistribution previousDeployedApplication, AppliedDistribution deployedApplication, List<Delta> deltas, boolean rollback) {
        this(operation, previousDeployedApplication, deployedApplication, deltas);
        this.rollback = rollback;
    }

    public DefaultDeltaSpecification(Operation operation, AppliedDistribution previousDeployedApplication, AppliedDistribution deployedApplication, List<Delta> deltas) {
        this.operation = operation;
        this.previousDeployedApplication = previousDeployedApplication;
        this.deployedApplication = deployedApplication;
        ArrayList deltas1 = Lists.newArrayList(deltas);
        Collections.sort(deltas1, new Comparator<Delta>(){

            @Override
            public int compare(Delta delta, Delta delta1) {
                Deployed d1 = delta.getOperation() != Operation.DESTROY ? delta.getDeployed() : delta.getPrevious();
                Deployed d2 = delta1.getOperation() != Operation.DESTROY ? delta1.getDeployed() : delta1.getPrevious();
                return d1.getName().compareTo(d2.getName());
            }
        });
        this.deltas = Collections.unmodifiableList(deltas1);
    }

    public Operation getOperation() {
        return this.operation;
    }

    public AppliedDistribution getPreviousAppliedDistribution() {
        return this.previousDeployedApplication;
    }

    public AppliedDistribution getAppliedDistribution() {
        return this.deployedApplication;
    }

    public DeployedApplication getPreviousDeployedApplication() {
        return (DeployedApplication)this.getPreviousAppliedDistribution();
    }

    public DeployedApplication getDeployedApplication() {
        return (DeployedApplication)this.getAppliedDistribution();
    }

    public List<Delta> getDeltas() {
        return this.deltas;
    }

    public boolean isRollback() {
        return this.rollback;
    }
}

