package com.xebialabs.deployit.deployment.planner

import java.io.Writer
import java.util.{List => juList}

import com.xebialabs.deployit.deployment.planner.StepPlan.Checkpoint
import com.xebialabs.deployit.engine.spi.execution.ExecutionStateListener

import scala.collection.convert.wrapAll._

class PhasedPlan(val phases: juList[PlanPhase], listeners: juList[ExecutionStateListener]) extends Plan("", listeners) {

  override def writePlan(writer: Writer) = {
    writer.append("# [Phased plan] " + this.getDescription)

    phases.foreach(_.writePlan(writer))
    writer
  }

  override def findCheckpoints(): juList[Checkpoint] = {
    val checkpoints = new java.util.ArrayList[Checkpoint]
    phases.flatMap(_.findCheckpoints()).toList.foreach(checkpoints.add)
    checkpoints
  }
}
