package com.xebialabs.deployit.deployment.rules

import javax.annotation.PreDestroy

import akka.actor.ActorSystem
import com.typesafe.config.ConfigFactory
import com.xebialabs.deployit.deployment.planner._
import com.xebialabs.deployit.deployment.stager.DeploymentStager
import com.xebialabs.xlplatform.watcher.FileWatchActor
import grizzled.slf4j.Logging

class RuleBasedPlannerFactory(val system: ActorSystem) extends Logging {

  private lazy val fileWatcherActor = system.actorOf(FileWatchActor.props, "file-watch-actor")
  private lazy val registriesActor = system.actorOf(RegistriesActor.props(fileWatcherActor), "registriesActor")

  def this() = this(ActorSystem("PlannerActorSystem", ConfigFactory.load("planner")))

  def planner: MultiDeploymentPlanner = {
    new SatelliteDeploymentPlanner(
      new DeploymentStager(
        new PlannerAggregator(
          new RepositoryUpdateStepPlanner(
            new SizeChunkingPlanner(
              new OrderChunkingPlanner(
                new FilterEmptyPhasePlanner(
                  new SimplifyingDeploymentPlanner(
                    new RuleBasedPlanner(registriesActor)))))))))
  }

  def plannerWithoutStaging: MultiDeploymentPlanner = {
    new SatelliteDeploymentPlanner(
      new PlannerAggregator(
        new RepositoryUpdateStepPlanner(
          new SizeChunkingPlanner(
            new OrderChunkingPlanner(
              new FilterEmptyPhasePlanner(
                new SimplifyingDeploymentPlanner(
                  new RuleBasedPlanner(registriesActor))))))))
  }

  @PreDestroy
  def shutdownTheSystem() = {
    debug("Shutting down the planning actor system...")
    system.shutdown()
  }
}
