package com.xebialabs.platform.settings

import java.util.concurrent.TimeUnit

import akka.actor._
import com.typesafe.config.Config

import scala.concurrent.duration._


class Settings(config: Config) extends Extension {
  object FileWatch {
    lazy val interval = config.getDuration("xl.file-watch.interval", TimeUnit.MILLISECONDS).millis
    lazy val pollingEnabled = config.hasPath("xl.file-watch.interval") && interval.toMillis > 0
  }
}

object Settings extends ExtensionId[Settings] with ExtensionIdProvider {
  override def lookup() = Settings

  override def createExtension(system: ExtendedActorSystem) = new Settings(system.settings.config)

  def apply(implicit context: ActorContext): Settings = apply(context.system)
}
