/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.booter.remote.xml;

import java.util.List;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

import com.xebialabs.deployit.booter.remote.RemotePropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xltype.serialization.xstream.XStreamProvider;

import static com.xebialabs.xltype.serialization.xstream.Converters.readList;


@XStreamProvider(tagName = "property-descriptor", readable = PropertyDescriptor.class)
public class PropertyDescriptorConverter implements Converter {
    @Override
    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        throw new IllegalStateException("Cannot serialize PropertyDescriptor from remote-booter");
    }

    @Override
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        final TypeProvider typeProvider = new RemoteTypeProvider(context);
        return doUnmarshal(reader, context, typeProvider);
    }

    protected RemotePropertyDescriptor doUnmarshal(final HierarchicalStreamReader reader, final UnmarshallingContext context, final TypeProvider typeProvider) {
        RemotePropertyDescriptor pd = new RemotePropertyDescriptor();
        setAttributes(pd, reader);
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            if ("referencedType".equals(reader.getNodeName())) {
                pd.setReferencedType(typeProvider.getType(reader.getValue()));
            } else if ("enumValues".equals(reader.getNodeName())) {
                reader.moveDown();
                List<String> strings = readList(pd, String.class, reader, context);
                reader.moveUp();
                pd.setEnumValues(strings);
            }
            reader.moveUp();
        }
        return pd;
    }

    private void setAttributes(RemotePropertyDescriptor pd, HierarchicalStreamReader reader) {
        pd.setName(reader.getAttribute("name"));
        pd.setFqn(reader.getAttribute("fqn"));
        pd.setLabel(reader.getAttribute("label"));
        pd.setKind(PropertyKind.valueOf(reader.getAttribute("kind")));
        pd.setDescription(reader.getAttribute("description"));
        pd.setCategory(reader.getAttribute("category"));
        pd.setCandidateValuesFilter(reader.getAttribute("candidateValuesFilter"));

        setDefaultValue(pd, reader);

        if ("true".equalsIgnoreCase(reader.getAttribute("hidden"))) {
            pd.setHidden();
        }
        if ("true".equalsIgnoreCase(reader.getAttribute("asContainment"))) {
            pd.setAsContainment();
        }
        if ("true".equalsIgnoreCase(reader.getAttribute("required"))) {
            pd.setRequired();
        }
        if ("true".equalsIgnoreCase(reader.getAttribute("inspection"))) {
            pd.setInspectionProperty();
        }
        if ("true".equalsIgnoreCase(reader.getAttribute("requiredInspection"))) {
            pd.setRequiredInspection();
        }
        if ("true".equalsIgnoreCase(reader.getAttribute("password"))) {
            pd.setPassword();
        }
        if ("true".equalsIgnoreCase(reader.getAttribute("transient"))) {
            pd.setTransient();
        }
        if (null != reader.getAttribute("size")) {
            pd.setSize(Property.Size.valueOf(reader.getAttribute("size")));
        }
    }

    private void setDefaultValue(RemotePropertyDescriptor pd, HierarchicalStreamReader reader) {
        String defaultValue = reader.getAttribute("default");
        switch (pd.getKind()) {
            case BOOLEAN:
                if (null == defaultValue) {
                    defaultValue = "false";
                }
                break;
            // INTEGER: not sure if 0 is sensible and expected default
        }
        if (defaultValue != null) {
            pd.setDefaultValue(defaultValue);
        }
    }

    @Override
    public boolean canConvert(Class type) {
        return PropertyDescriptor.class.equals(type);
    }
}
