/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.booter.remote.client;

import com.thoughtworks.xstream.converters.DataHolder;
import com.thoughtworks.xstream.core.MapBackedDataHolder;

import com.xebialabs.deployit.booter.remote.BooterConfig;
import com.xebialabs.xltype.serialization.xstream.XStreamReaderWriter;

public class ClientXStreamReaderWriter extends XStreamReaderWriter {

    private final BooterConfig booterConfig;

    public ClientXStreamReaderWriter(final BooterConfig booterConfig) {
        this.booterConfig = booterConfig;
    }

    @Override
    protected DataHolder createDataHolder() {
        MapBackedDataHolder dataHolder = new MapBackedDataHolder();
        dataHolder.put("BOOTER_CONFIG", booterConfig.getKey());
        return dataHolder;
    }
}
