/**
 * Copyright © 2014-2016 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.booter.remote.xml;

import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.xebialabs.deployit.booter.remote.execution.RemotePhaseState;
import com.xebialabs.deployit.engine.api.execution.BlockState;

class RemotePhaseReader extends BlockReader {
    private UnmarshallingContext context;

    public RemotePhaseReader(HierarchicalStreamReader reader, UnmarshallingContext context) {
        super(reader);
        this.context = context;
    }

    @Override
    public BlockState read() {
        RemotePhaseState phase = new RemotePhaseState();

        setCommonPropertiesOn(phase);

        reader.moveDown();
        BlockState blockState = (BlockState) context.convertAnother(phase, BlockState.class);
        reader.moveUp();

        phase.setBlock(blockState);

        return phase;
    }
}
