/**
 * Copyright © 2014-2016 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.booter.remote;

import org.apache.http.client.HttpClient;

import java.io.IOException;

import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpUriRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;

public class DeployitCommunicator {
    private HttpClientHolder httpClientHolder;
    private BooterConfig config;

    public DeployitCommunicator(BooterConfig config) {
        this.config = config;
        this.httpClientHolder = new HttpClientHolder(config);
    }

    public void shutdown() {
        logger.info("Shutting down {}", config);
        httpClientHolder.shutdown();
        // Callback to remove from the COMMUNICATORS map.
        RemoteBooter.remove(config);
        DescriptorRegistry.remove(config);
    }

    public Proxies proxies() {
        return httpClientHolder.getProxies();
    }

    public Type getType(String typeName) {
        return DescriptorRegistry.getDescriptorRegistry(config).lookupType(typeName);
    }

    public HttpClientHolder getHttpClientHolder() {
        return httpClientHolder;
    }

    public String getUsername() {
        return httpClientHolder.getUserName();
    }

    public HttpResponse execute(HttpUriRequest httpPost) throws ClientProtocolException, IOException {
        return httpClientHolder.execute(httpPost);
    }

    public Proxies getProxies() {
        return httpClientHolder.getProxies();
    }

    public BooterConfig getConfig() {
        return config;
    }

    public HttpClient httpClient() {
        return httpClientHolder.getHttpClient();
    }

    private static final Logger logger = LoggerFactory.getLogger(DeployitCommunicator.class);

}
