/**
 * Copyright © 2014-2016 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.booter.remote.xml;

import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.xebialabs.deployit.booter.remote.execution.RemotePhaseContainerState;
import com.xebialabs.deployit.engine.api.execution.BlockState;
import com.xebialabs.deployit.engine.api.execution.PhaseState;
import com.xebialabs.xltype.serialization.xstream.Converters;

import java.util.List;

class RemotePhaseContainerReader extends BlockReader {
    private UnmarshallingContext context;

    public RemotePhaseContainerReader(HierarchicalStreamReader reader, UnmarshallingContext context) {
        super(reader);
        this.context = context;
    }

    @Override
    public BlockState read() {
        RemotePhaseContainerState block = new RemotePhaseContainerState();

        setCommonPropertiesOn(block);

        List<PhaseState> phaseStates = Converters.readList(block, PhaseState.class, reader, context);

        block.setBlocks(phaseStates);

        return block;
    }

}
