/**
 * Copyright 2014-2018 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.booter.remote.xml;

import java.util.ArrayList;
import java.util.List;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;

import com.xebialabs.deployit.booter.remote.execution.RemoteTaskWithBlock;
import com.xebialabs.deployit.engine.api.execution.BlockState;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.xltype.serialization.util.DateUtil;
import com.xebialabs.xltype.serialization.xstream.AbstractTaskWithBlockConverter;
import com.xebialabs.xltype.serialization.xstream.DateTimeAdapter;

public class TaskWithBlockConverter extends AbstractTaskWithBlockConverter {

    @Override
    public Object unmarshal(final HierarchicalStreamReader reader, final UnmarshallingContext context) {

        RemoteTaskWithBlock task = new RemoteTaskWithBlock();
        task.setId(reader.getAttribute("id"));
        task.setFailureCount(Integer.valueOf(reader.getAttribute("failures")));
        task.setState(TaskExecutionState.valueOf(reader.getAttribute("state")));
        task.setOwner(reader.getAttribute("owner"));

        boolean hasBlockNode = false;
        List<String> activeBlocks = new ArrayList<>();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            if ("description".equals(reader.getNodeName())) {
                task.setDescription(reader.getValue());
            } else if ("startDate".equals(reader.getNodeName())) {
                task.setStartDate(DateUtil.fromString(reader.getValue()));
            } else if ("completionDate".equals(reader.getNodeName())) {
                task.setCompletionDate(DateUtil.fromString(reader.getValue()));
            } else if ("scheduledDate".equals(reader.getNodeName())) {
                task.setScheduledDate(DateUtil.fromString(reader.getValue()));

            } else if ("metadata".equals(reader.getNodeName())) {
                while (reader.hasMoreChildren()) {
                    reader.moveDown();
                    task.getMetadata().put(reader.getNodeName(), reader.getValue());
                    reader.moveUp();
                }
            } else if ("activeBlocks".equals(reader.getNodeName())) {
                while (reader.hasMoreChildren()) {
                    reader.moveDown();
                    activeBlocks.add(reader.getValue());
                    reader.moveUp();
                }
            } else if ("block".equals(reader.getNodeName())) {
                hasBlockNode = true;
                BlockState blockState = (BlockState) context.convertAnother(task, BlockState.class);
                task.setBlock(blockState);
            }
            reader.moveUp();
        }
        if(!hasBlockNode){
            throw new IllegalArgumentException("Task xml node that was expected to be a TaskWithBlock did not have a block child node, is the xml correct?");
        }
        task.setActiveBlocks(activeBlocks);

        return task;
    }

}
