/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.booter.remote.xml;

import com.thoughtworks.xstream.converters.UnmarshallingContext;

import com.xebialabs.deployit.booter.remote.DeployitCommunicator;
import com.xebialabs.deployit.booter.remote.RemoteBooter;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistryId;
import com.xebialabs.deployit.plugin.api.reflect.Type;

/**
 * Implementation of {@link TypeProvider} to get {@link Type} from the {@link DeployitCommunicator}.
 */
public class RemoteTypeProvider implements TypeProvider {

    private DeployitCommunicator communicator;

    RemoteTypeProvider(final UnmarshallingContext context) {
        String booterConfigKey = (String) context.get("BOOTER_CONFIG");
        this.communicator = RemoteBooter.getCommunicator(booterConfigKey);
    }

    @Override
    public Type getType(final String value) {
        return communicator.getType(value);
    }

    @Override
    public DescriptorRegistryId getTypeSource() {
        return communicator.getConfig();
    }


}
