/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.booter.remote;

import com.xebialabs.deployit.plugin.api.reflect.*;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.*;
import java.util.function.Function;

@SuppressWarnings("serial")
public class RemotePropertyDescriptor implements PropertyDescriptor, Serializable {
    static final Field syntheticField = initSyntheticField();
    private final DescriptorRegistryId typeSource;

    private static Field initSyntheticField() {
        try {
            Field f = BaseConfigurationItem.class.getDeclaredField(BaseConfigurationItem.SYNTHETIC_PROPERTIES_FIELD);
            f.setAccessible(true);
            return f;
        } catch (NoSuchFieldException e) {
            throw new IllegalStateException("Could not find the Synthetic property field.");
        }
    }

    public RemotePropertyDescriptor(DescriptorRegistryId typeSource) {
        this.typeSource = typeSource;
    }

    private String name;
    private String label;
    private PropertyKind kind;
    private List<String> enumValues = new ArrayList<>();
    private Type referencedType;
    private String description;
    private String category;
    private String defaultValue;
    private boolean password;
    private boolean required;
    private boolean containment = false;
    private boolean nested = false;
    private int order = 0;
    private boolean isTransient;
    private Property.Size size;
    private boolean inspectionProperty;
    private boolean requiredInspection;
    private String fqn;
    private String candidateValuesFilter;
    private boolean hidden = false;
    private boolean readonly = false;

    @Override
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public boolean isAsContainment() {
        return containment;
    }

    public void setAsContainment() {
        containment = true;
    }

    @Override
    public boolean isNested() {
        return nested;
    }

    @Override
    public int getOrder() {
        return order;
    }

    public void setNested(final boolean nested) {
        this.nested = nested;
    }

    @Override
    public String getCategory() {
        return category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    @Override
    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public boolean isPassword() {
        return password;
    }

    public void setPassword() {
        password = true;
    }

    @Override
    public boolean isRequired() {
        return required;
    }

    public void setRequired() {
        required = true;
    }

    @Override
    public Property.Size getSize() {
        return size;
    }

    public void setSize(Property.Size size) {
        this.size = size;
    }

    @Override
    public PropertyKind getKind() {
        return kind;
    }

    public void setKind(PropertyKind kind) {
        this.kind = kind;
    }

    @Override
    public List<String> getEnumValues() {
        return enumValues;
    }

    public void setEnumValues(List<String> enumValues) {
        this.enumValues = enumValues;
    }

    @Override
    public Type getReferencedType() {
        return referencedType;
    }

    public void setReferencedType(Type referencedType) {
        this.referencedType = referencedType;
    }

    @Override
    public Object getDefaultValue() {
        return defaultValue;
    }

    @Override
    public DescriptorRegistryId getTypeSource() {
        return this.typeSource;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public boolean isTransient() {
        return isTransient;
    }

    public void setTransient() {
        isTransient = true;
    }

    @Override
    public String getCandidateValuesFilter() {
        return candidateValuesFilter;
    }

    public void setCandidateValuesFilter(String candidateValuesFilter) {
        this.candidateValuesFilter = candidateValuesFilter;
    }

    @Override
    public Object get(ConfigurationItem item) {
        try {
            @SuppressWarnings("unchecked")
            Map<String, Object> props = (Map<String, Object>) syntheticField.get(item);
            return props.get(name);
        } catch (IllegalAccessException e) {
            throw new IllegalStateException("Could not access Synthetic properties...");
        }
    }

    @Override
    public void set(ConfigurationItem item, Object value) {
        if (this.isReadonly() && this.get(item) != null) {
            throw new IllegalArgumentException(String.format("Readonly property [%s] cannot be updated", this.getName()));
        }
        // TODO! Conversion
        try {
            @SuppressWarnings("unchecked")
            Map<String, Object> props = (Map<String, Object>) syntheticField.get(item);
            props.put(name, PropertyConverter.convertValue(kind, value));
        } catch (IllegalAccessException e) {
            throw new IllegalStateException("Could not access Synthetic properties...");
        }
    }

    @Override
    public boolean areEqual(ConfigurationItem item, ConfigurationItem other) {
        // TODO implement
        return false;  //To change body of implemented methods use File | Settings | File Templates.
    }

    @Override
    public boolean areEqual(ConfigurationItem item,
                            ConfigurationItem other,
                            Function<ConfigurationItem, Object> identifierExtractor) {
        return false;
    }

    @Override
    public String getFqn() {
        return fqn;
    }

    public void setFqn(String fqn) {
        this.fqn = fqn;
    }

    @Override
    public boolean isRequiredForInspection() {
        return requiredInspection;
    }

    public void setRequiredInspection() {
        this.requiredInspection = true;
    }

    @Override
    public boolean isHidden() {
        return hidden;
    }

    public void setHidden() {
        this.hidden = true;
    }

    @Override
    public boolean isReadonly() {
        return readonly;
    }

    public void setReadonly() {
        this.readonly = true;
    }

    @Override
    public boolean isInspectionProperty() {
        return inspectionProperty;
    }

    public void setInspectionProperty() {
        this.inspectionProperty = true;
    }

    @Override
    public Set<String> getAliases() {
        return new HashSet<>();
    }

    public boolean isDeployedSpecific() {
        return false;
    }

    @Override
    public InputHint getInputHint() {
        return null;
    }

    @Override
    public List<Annotation> getAnnotations() {
        return Collections.emptyList();
    }
}
