/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.remote;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.xebialabs.deployit.booter.remote.Proxies;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class RemoteDescriptorRegistry
extends DescriptorRegistry {
    private final Map<Type, Descriptor> descriptors = Maps.newHashMap();
    private final Multimap<Type, Type> subtypes = HashMultimap.create();

    protected Collection<Descriptor> _getDescriptors() {
        return this.descriptors.values();
    }

    protected Collection<Type> _getSubtypes(Type supertype) {
        return this.subtypes.get((Object)supertype);
    }

    protected Descriptor _getDescriptor(Type type) {
        return this.descriptors.get(type);
    }

    protected boolean _exists(Type type) {
        return this.descriptors.containsKey(type);
    }

    public static void boot() {
        List list = Proxies.getMetadataService().listDescriptors();
        RemoteDescriptorRegistry instance = (RemoteDescriptorRegistry)RemoteDescriptorRegistry.getInstance();
        for (Descriptor descriptor : list) {
            instance.register(descriptor);
        }
    }

    private void register(Descriptor descriptor) {
        this.descriptors.put(descriptor.getType(), descriptor);
        for (Type type : descriptor.getSuperClasses()) {
            this.subtypes.put((Object)type, (Object)descriptor.getType());
        }
        for (Type type : descriptor.getInterfaces()) {
            this.subtypes.put((Object)type, (Object)descriptor.getType());
        }
    }
}

