package com.xebialabs.deployit.booter.remote.xml;

import java.util.Map;
import com.google.common.base.Strings;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

import com.xebialabs.deployit.booter.remote.RemoteMethodDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.MethodDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xltype.serialization.xstream.XStreamProvider;

import static com.google.common.collect.Maps.newHashMap;

@XStreamProvider(tagName = "control-task", readable = MethodDescriptor.class)
public class MethodDescriptorConverter implements Converter {

    @Override
    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        throw new IllegalStateException("Cannot serialize MethodDescriptor from remote-booter");
    }

    @Override
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        RemoteMethodDescriptor methodDescriptor = new RemoteMethodDescriptor();
        readXmlAttributes(reader, methodDescriptor);

        while (reader.hasMoreChildren()) {
            reader.moveDown();
            if (reader.getNodeName().equals("attributes")) {
                methodDescriptor.setAttributes(readAttributes(reader));
            }
            reader.moveUp();
        }

        return methodDescriptor;
    }

    private void readXmlAttributes(final HierarchicalStreamReader reader, final RemoteMethodDescriptor methodDescriptor) {
        methodDescriptor.setName(reader.getAttribute("name"));
        methodDescriptor.setFqn(reader.getAttribute("fqn"));
        methodDescriptor.setDescription(reader.getAttribute("description"));
        methodDescriptor.setLabel(reader.getAttribute("label"));
        String attribute = reader.getAttribute("parameters-type");
        if (!Strings.isNullOrEmpty(attribute)) {
            methodDescriptor.setParameterObjectType(Type.valueOf(attribute));
        }
    }

    private Map<String, String> readAttributes(final HierarchicalStreamReader reader) {
        Map<String, String> map = newHashMap();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            map.put(reader.getNodeName(), reader.getValue());
            reader.moveUp();
        }
        return map;
    }

    @Override
    public boolean canConvert(Class type) {
        return MethodDescriptor.class.equals(type);
    }
}
