/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.remote.service;

import com.xebialabs.deployit.booter.remote.BooterConfig;
import com.xebialabs.deployit.booter.remote.DeployitCommunicator;
import com.xebialabs.deployit.booter.remote.Proxies;
import com.xebialabs.deployit.booter.remote.resteasy.DeployitClientException;
import com.xebialabs.deployit.engine.api.PackageService;
import com.xebialabs.deployit.engine.api.dto.FileUpload;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xltype.serialization.xstream.XStreamReaderWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.util.EntityUtils;

public class StreamingImportingService
implements PackageService {
    private DeployitCommunicator communicator;
    private Proxies proxies;

    public StreamingImportingService(DeployitCommunicator communicator, Proxies proxies) {
        this.communicator = communicator;
        this.proxies = proxies;
    }

    public List<String> list() {
        return this.getPackageProxy().list();
    }

    private PackageService getPackageProxy() {
        return this.proxies.getProxyInstance(PackageService.class);
    }

    public ConfigurationItem importPackage(String file) {
        return this.getPackageProxy().importPackage(file);
    }

    public ConfigurationItem fetch(String url) {
        return this.getPackageProxy().fetch(url);
    }

    public ConfigurationItem upload(String file, FileUpload form) {
        if (!(form instanceof LocalFileUpload)) {
            throw new IllegalArgumentException();
        }
        File fileToUpload = ((LocalFileUpload)form).getFile();
        try {
            return this.responseToCi(this.communicator.getHttpClientHolder().getHttpClient().execute((HttpUriRequest)this.httpPost(fileToUpload)));
        }
        catch (IOException e) {
            throw new ImportException("Failed to import dar file", e);
        }
    }

    private HttpPost httpPost(File file) {
        BooterConfig config = this.communicator.getConfig();
        MultipartEntity multipartEntity = new MultipartEntity();
        multipartEntity.addPart("fileData", (ContentBody)new FileBody(file));
        HttpPost post = new HttpPost(config.getUrl() + "/package/upload/" + file.getName());
        post.setEntity((HttpEntity)multipartEntity);
        return post;
    }

    private ConfigurationItem responseToCi(HttpResponse response) {
        try {
            ConfigurationItem configurationItem;
            int statusCode = response.getStatusLine().getStatusCode();
            if (!StreamingImportingService.isOk(statusCode)) {
                StreamingImportingService.tryDeployitException(response);
                StreamingImportingService.tryUnhandledException(response);
                throw new RuntimeException("Failed : HTTP error code : " + statusCode);
            }
            ConfigurationItem configurationItem2 = configurationItem = (ConfigurationItem)XStreamReaderWriter.getConfiguredXStream().fromXML(response.getEntity().getContent());
            return configurationItem2;
        }
        catch (IOException e) {
            throw new ImportException("Failed to import dar file", e);
        }
        finally {
            if (response != null) {
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private static boolean isOk(int statusCode) {
        return statusCode < 300;
    }

    private static void tryDeployitException(HttpResponse response) throws IOException {
        if (response.containsHeader("X-Deployit-Exception")) {
            Header header = response.getHeaders("X-Exception-Type")[0];
            String value = header.getValue();
            String message = EntityUtils.toString((HttpEntity)response.getEntity());
            throw new DeployitClientException(value + ":" + message, response.getStatusLine().getStatusCode());
        }
    }

    private static void tryUnhandledException(HttpResponse response) throws IOException {
        if (response.containsHeader("Unhandled-Exception")) {
            Header header = response.getHeaders("Exception-Type")[0];
            String exceptionType = header.getValue();
            String unhandledMessage = EntityUtils.toString((HttpEntity)response.getEntity());
            throw new RuntimeException(String.format("%s: %s", exceptionType, unhandledMessage));
        }
    }

    public static class ImportException
    extends RuntimeException {
        public ImportException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class LocalFileUpload
    extends FileUpload {
        private File file;

        public LocalFileUpload(File file) throws FileNotFoundException {
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }

        public InputStream getFileData() {
            try {
                return new FileInputStream(this.file);
            }
            catch (FileNotFoundException e) {
                throw new ImportException("Can not open file", e);
            }
        }
    }
}

