/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.remote;

import com.xebialabs.deployit.booter.remote.BooterConfig;
import com.xebialabs.deployit.booter.remote.HttpClientHolder;
import com.xebialabs.deployit.booter.remote.Proxies;
import com.xebialabs.deployit.booter.remote.RemoteBooter;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistryId;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployitCommunicator {
    private final HttpClientHolder httpClientHolder;
    private final Proxies proxies;
    private BooterConfig config;
    private String serverVersion;
    private static final Logger logger = LoggerFactory.getLogger(DeployitCommunicator.class);

    public DeployitCommunicator(BooterConfig config) {
        this.config = config;
        this.httpClientHolder = new HttpClientHolder(config);
        this.tryAuthenticate(config);
        this.proxies = new Proxies(this);
        this.serverVersion = this.proxies.getServerService().getInfo().getVersion();
        logger.debug("Detected XL Deploy server version: {}", (Object)this.serverVersion);
    }

    public HttpClient httpClient() {
        return this.httpClientHolder.getHttpClient();
    }

    public HttpContext httpContext() {
        return this.httpClientHolder.getHttpContext();
    }

    public void shutdown() {
        logger.info("Shutting down {}", (Object)this.config);
        this.httpClientHolder.shutdown();
        RemoteBooter.remove(this.config);
        DescriptorRegistry.remove((DescriptorRegistryId)this.config);
    }

    public Proxies proxies() {
        return this.proxies;
    }

    public Type getType(String typeName) {
        return DescriptorRegistry.getDescriptorRegistry((DescriptorRegistryId)this.config).lookupType(typeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryAuthenticate(BooterConfig config) {
        block9: {
            String urlToConnectTo = config.getUrl();
            logger.info("Connecting to the Deployit server at {}...", (Object)urlToConnectTo);
            try {
                HttpResponse execute = this.httpClient().execute((HttpUriRequest)new HttpGet(urlToConnectTo + "/server/info"), this.httpContext());
                try {
                    int responseCode = execute.getStatusLine().getStatusCode();
                    if (responseCode == 200) {
                        logger.info("Successfully connected.");
                        break block9;
                    }
                    if (responseCode == 401 || responseCode == 403) {
                        throw new IllegalStateException("You were not authenticated correctly, did you use the correct credentials?");
                    }
                    if (responseCode == 402) {
                        throw new IllegalStateException("License not found, invalid, or expired; see the Deployit logs. Please contact your XebiaLabs sales representative for a valid license.");
                    }
                    throw new IllegalStateException("Could contact the server at " + urlToConnectTo + " but received an HTTP error code, " + responseCode);
                }
                finally {
                    EntityUtils.consume((HttpEntity)execute.getEntity());
                    this.httpClient().getConnectionManager().closeIdleConnections(0L, TimeUnit.MILLISECONDS);
                }
            }
            catch (MalformedURLException mue) {
                throw new IllegalStateException("Could not contact the server at " + urlToConnectTo, mue);
            }
            catch (IOException e) {
                throw new IllegalStateException("Could not contact the server at " + urlToConnectTo, e);
            }
        }
    }

    public HttpClientHolder getHttpClientHolder() {
        return this.httpClientHolder;
    }

    public Proxies getProxies() {
        return this.proxies;
    }

    public BooterConfig getConfig() {
        return this.config;
    }

    public String getServerVersion() {
        return this.serverVersion;
    }
}

