package com.xebialabs.deployit.booter.remote.xml;

import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;

import com.xebialabs.deployit.booter.remote.execution.RemoteStepState;
import com.xebialabs.deployit.engine.api.execution.StepExecutionState;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.xltype.serialization.xstream.AbstractStepConverter;
import com.xebialabs.xltype.serialization.xstream.DateTimeAdapter;
import com.xebialabs.xltype.serialization.xstream.XStreamProvider;

@XStreamProvider(readable = StepState.class, tagName = "step")
public class StepConverter extends AbstractStepConverter {
    @Override
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        RemoteStepState s = new RemoteStepState();
        s.setFailureCount(Integer.valueOf(reader.getAttribute("failures")));
        s.setState(StepExecutionState.valueOf(reader.getAttribute("state")));

        while (reader.hasMoreChildren()) {
            reader.moveDown();
            if ("description".equals(reader.getNodeName())) {
                s.setDescription(reader.getValue());
            } else if ("startDate".equals(reader.getNodeName())) {
                s.setStartDate(new DateTimeAdapter().fromString(reader.getValue()));
            } else if ("completionDate".equals(reader.getNodeName())) {
                s.setCompletionDate(new DateTimeAdapter().fromString(reader.getValue()));
            } else if ("log".equals(reader.getNodeName())) {
                s.setLog(reader.getValue());
            } else if ("metadata".equals(reader.getNodeName())) {
                while (reader.hasMoreChildren()) {
                    reader.moveDown();
                    s.getMetadata().put(reader.getNodeName(), reader.getValue());
                    reader.moveUp();
                }
            }
            reader.moveUp();
        }
        return s;
    }
}
