package com.xebialabs.deployit.booter.remote.xml;

import java.util.List;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;

import com.xebialabs.deployit.booter.remote.execution.RemoteBlockState;
import com.xebialabs.deployit.booter.remote.execution.RemoteCompositeBlockState;
import com.xebialabs.deployit.booter.remote.execution.RemoteStepBlockState;
import com.xebialabs.deployit.engine.api.execution.*;
import com.xebialabs.xltype.serialization.xstream.AbstractBlockConverter;
import com.xebialabs.xltype.serialization.xstream.Converters;
import com.xebialabs.xltype.serialization.xstream.XStreamProvider;

@XStreamProvider(readable = BlockState.class, tagName = "block")
public class BlockConverter extends AbstractBlockConverter {

    @Override
    public Object unmarshal(final HierarchicalStreamReader reader, final UnmarshallingContext context) {

        BlockState block;
        if (reader.getAttribute("current") != null) {
            block = new RemoteStepBlockState();
            readStepBlockState(reader, context, (RemoteStepBlockState) block);
        } else if(reader.getAttribute("parallel") != null){
            block = new RemoteCompositeBlockState();
            readCompositeBlockState(reader, context, (RemoteCompositeBlockState) block);
        } else {
            block = new RemoteBlockState();
            readBlockState(reader, context, (RemoteBlockState) block);
        }
        return block;
    }

    private void readBlockState(final HierarchicalStreamReader reader, final UnmarshallingContext context, final RemoteBlockState block) {
        block.setId(reader.getAttribute("id"));
        block.setDescription(reader.getAttribute("description"));
        block.setState(BlockExecutionState.valueOf(reader.getAttribute("state")));
    }

    private void readCompositeBlockState(final HierarchicalStreamReader reader, final UnmarshallingContext context, final RemoteCompositeBlockState block) {
        readBlockState(reader, context, block);
        block.setParallel(Boolean.parseBoolean(reader.getAttribute("parallel")));
        List<BlockState> blockStates = Converters.readList(block, BlockState.class, reader, context);
        block.setBlocks(blockStates);
    }

    private void readStepBlockState(final HierarchicalStreamReader reader, final UnmarshallingContext context, final RemoteStepBlockState block) {
        readBlockState(reader, context, block);
        block.setCurrentStep(Integer.parseInt(reader.getAttribute("current")));
        List<StepState> stepStates = Converters.readList(block, StepState.class, reader, context);
        block.setSteps(stepStates);
    }

}
