/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.engine.unicode;

import com.xebialabs.deployit.engine.unicode.BOM;
import com.xebialabs.overthere.util.OverthereUtils;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DetectBOM {
    private static Logger logger = LoggerFactory.getLogger(DetectBOM.class);

    private DetectBOM() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BOM detect(TFile file) throws IOException {
        logger.debug("Reading first bytes of [{}] to detect the BOM", (Object)file);
        TFileInputStream reader = new TFileInputStream((File)file);
        try {
            BOM bom = BOM.NONE;
            int value = reader.read();
            if (value == 239) {
                if (reader.read() == 187 && reader.read() == 191) {
                    bom = BOM.UTF8;
                }
            } else if (value == 254) {
                if (reader.read() == 255) {
                    bom = BOM.UTF16BE;
                }
            } else if (value == 255 && reader.read() == 254) {
                bom = BOM.UTF16LE;
            }
            if (bom.isDefaultCharset()) {
                logger.debug("BOM [{}] detected in [{}], using default charset", (Object)bom, (Object)file);
            } else {
                logger.debug("BOM [{}] detected in [{}], using charset [{}]", new Object[]{bom, file, bom.getCharset()});
            }
            BOM bOM = bom;
            return bOM;
        }
        finally {
            OverthereUtils.closeQuietly((Closeable)reader);
        }
    }
}

