package com.xebialabs.deployit.engine.unicode;

import java.io.IOException;
import java.io.InputStream;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.common.io.Closeables;

import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;

public class DetectBOM {

    private DetectBOM() {
    }

    public static BOM detect(TFile file) throws IOException {
        logger.debug("Reading first bytes of [{}] to detect the BOM", file);

        InputStream reader = new TFileInputStream(file);
        try {
            BOM bom = BOM.NONE;

            int value = reader.read();
            if (value == 0xef) {
                if (reader.read() == 0xBB && reader.read() == 0xBF) {
                    bom = BOM.UTF8;
                }
            } else if (value == 0xFE) {
                if (reader.read() == 0xFF) {
                    bom = BOM.UTF16BE;
                }
            } else if (value == 0xFF) {
                if (reader.read() == 0xFE) {
                    bom = BOM.UTF16LE;
                }
            }

            if (bom.isDefaultCharset()) {
                logger.debug("BOM [{}] detected in [{}], using default charset", bom, file);
            } else {
                logger.debug("BOM [{}] detected in [{}], using charset [{}]", bom, file, bom.getCharset());
            }
            return bom;
        } finally {
            Closeables.closeQuietly(reader);
        }
    }

    private static Logger logger = LoggerFactory.getLogger(DetectBOM.class);

}
