package com.xebialabs.deployit.engine.unicode;

import java.nio.charset.Charset;

import com.google.common.base.Charsets;

public enum BOM {

    NONE("NONE", new byte[] {}, null),
    UTF8("UTF-8", new byte[] { (byte) 0xEF, (byte) 0xBB, (byte) 0xBF }, Charsets.UTF_8),
    UTF16BE("UTF-16BE", new byte[] { (byte) 0xFE, (byte) 0xFF }, Charsets.UTF_16BE),
    UTF16LE("UTF-16LE", new byte[] { (byte) 0xFF, (byte) 0xFE }, Charsets.UTF_16LE);

    private final String name;
    private final byte[] bom;
    private Charset charset;

    BOM(String encoding, byte[] bom, Charset charset) {
        this.name = encoding;
        this.bom = bom;
        this.charset = charset;
    }

    public String getName() {
        return name;
    }

    public boolean isDefaultCharset() {
        return charset == null;
    }

    public Charset getCharset() {
        return charset;
    }

    public int getSize() {
        return bom.length;
    }

    public byte[] getBom() {
        return bom.clone();
    }

    public String toString() {
        return name;
    }

}
