/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.engine.tasker;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.engine.api.execution.StepExecutionState;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.engine.api.execution.TaskState;
import com.xebialabs.deployit.engine.tasker.EventBusAdapter;
import com.xebialabs.deployit.engine.tasker.StepEvent;
import com.xebialabs.deployit.engine.tasker.Task;
import com.xebialabs.deployit.engine.tasker.TaskEvent;
import com.xebialabs.deployit.engine.tasker.TaskExecutionContext;
import com.xebialabs.deployit.engine.tasker.TaskStep;
import com.xebialabs.deployit.engine.tasker.step.PauseStep;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import java.util.List;
import java.util.concurrent.FutureTask;
import nl.javadude.t2bus.BusException;
import nl.javadude.t2bus.EventHandlerStrategy;
import nl.javadude.t2bus.event.strategy.ThrowingEventHandlerStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class TaskRunner
implements Runnable {
    private static final String MDC_KEY_TASK_ID = "taskId";
    private static final String MDC_KEY_STEP_DESCRIPTION = "stepDescription";
    private static final String MDC_KEY_USERNAME = "username";
    private volatile Task task;
    private volatile boolean stopRequested;
    private volatile FutureTask<Object> threadHandle;
    private TaskExecutionContext context;
    private ExecutionContext executionContext;
    private static final Logger logger = LoggerFactory.getLogger(TaskRunner.class);

    public TaskRunner(Task task) {
        this.task = task;
        this.context = task.getContext();
        this.context.initWithBus(new EventBusAdapter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        MDC.put((String)MDC_KEY_TASK_ID, (String)this.task.getId());
        MDC.put((String)MDC_KEY_USERNAME, (String)this.task.getOwner());
        this.task.recordStart();
        try {
            this.stopRequested = false;
            Preconditions.checkState((this.task.getState() == TaskExecutionState.QUEUED ? 1 : 0) != 0, (Object)"Task should be queued");
            Preconditions.checkState((this.threadHandle != null ? 1 : 0) != 0, (Object)"task should have a wrapper set!");
            try {
                if (this.task.getCurrentStep() == null) {
                    this.nextStep();
                } else {
                    this.executionContext = this.task.getCurrentStep().getContext(this.context);
                }
                this.setTaskState(TaskExecutionState.EXECUTING);
                boolean result = this.executeSteps();
                if (!result && this.isAborted()) {
                    logger.debug("Task aborted.");
                    this.task.recordFailure();
                    this.setTaskState(TaskExecutionState.STOPPED);
                } else if (!result && this.stopRequested) {
                    logger.debug("Stopped the task.");
                    this.task.recordFailure();
                    this.setTaskState(TaskExecutionState.STOPPED);
                } else if (!result) {
                    logger.debug("Step failed: {}", (Object)this.task.getCurrentStep());
                    this.task.recordFailure();
                    this.setTaskState(TaskExecutionState.STOPPED);
                } else {
                    logger.debug("Executed all steps of {}", (Object)this.task);
                    this.task.recordCompletion();
                    this.setTaskState(TaskExecutionState.EXECUTED);
                }
            }
            catch (RuntimeException re) {
                this.executionContext.logError("Task failed.", (Throwable)re);
                throw re;
            }
            finally {
                this.threadHandle = null;
                Thread.interrupted();
            }
        }
        finally {
            MDC.remove((String)MDC_KEY_TASK_ID);
        }
    }

    public void queue() {
        Preconditions.checkState((boolean)this.canBeQueued(), (String)"Can only queue a task that is PENDING, state is now [%s]", (Object[])new Object[]{this.task.getState()});
        this.setTaskState(TaskExecutionState.QUEUED);
    }

    public void abort() {
        if (this.isExecuting()) {
            this.threadHandle.cancel(true);
        } else {
            logger.info("Cannot abort task [{}] which is not currently executing.", (Object)this.task.getId());
        }
    }

    public void cancel() {
        Preconditions.checkArgument((this.canBeQueued() || this.isReadyForExecution() ? 1 : 0) != 0, (String)"Can only cancel a task that is PENDING, QUEUED or STOPPED; state is now [%s]", (Object[])new Object[]{this.task.getState()});
        this.task.recordCompletion();
        this.setTaskState(TaskExecutionState.CANCELLED);
    }

    public void stop() {
        this.stopRequested = true;
    }

    public void archive() {
        Preconditions.checkState((this.task.getState() == TaskExecutionState.EXECUTED ? 1 : 0) != 0, (Object)"Task can only be archived if it has been executed.");
        this.setTaskState(TaskExecutionState.DONE);
    }

    public void skip(int stepNr) {
        Preconditions.checkState((boolean)this.canBeQueued(), (String)"Task [%s] should be PENDING or STOPPED, [%s]", (Object[])new Object[]{this.task.getId(), this.task.getState()});
        TaskStep step = this.task.getStep(stepNr);
        Preconditions.checkArgument((boolean)step.canSkip(), (String)"Step [%s] cannot be skipped.", (Object[])new Object[]{stepNr});
        this.setStepState(step, StepExecutionState.SKIP);
    }

    public void unskip(Integer stepNr) {
        Preconditions.checkState((boolean)this.canBeQueued(), (String)"Task [%s] should be PENDING or STOPPED, [%s]", (Object[])new Object[]{this.task.getId(), this.task.getState()});
        TaskStep step = this.task.getStep(stepNr);
        Preconditions.checkArgument((boolean)step.isMarkedForSkip(), (String)"Step [%s] cannot be un-skipped", (Object[])new Object[]{stepNr});
        this.setStepState(step, StepExecutionState.PENDING);
    }

    public void moveStep(int stepNr, int newPosition) {
        Preconditions.checkState((this.task.getState() == TaskExecutionState.PENDING && this.task.getCurrentStepNr() == 0 ? 1 : 0) != 0, (String)"Task should not have run when moving steps, [%s]", (Object[])new Object[]{this.task.getId()});
        List<TaskStep> taskSteps = this.task.getTaskSteps();
        int index = this.task.stepNrToIndex(stepNr);
        int index1 = this.task.stepNrToIndex(newPosition);
        TaskStep moved = taskSteps.remove(index);
        taskSteps.add(index1, moved);
    }

    public void addPause(int position) {
        Preconditions.checkState((boolean)this.canBeQueued(), (String)"Task [%s] should be PENDING or STOPPED, [%s]", (Object[])new Object[]{this.task.getId(), this.task.getState()});
        Preconditions.checkState((this.task.getCurrentStepNr() < position ? 1 : 0) != 0, (String)"Can only add pause steps after the current execution position (currently: [%s], requested: [%s])", (Object[])new Object[]{this.task.getCurrentStepNr(), position});
        this.task.getTaskSteps().add(this.task.stepNrToIndex(position), new TaskStep(new PauseStep()));
    }

    void setThreadHandle(FutureTask<Object> future) {
        this.threadHandle = future;
    }

    public Task getTask() {
        return this.task;
    }

    private boolean executeSteps() {
        while (this.hasMoreSteps()) {
            TaskStep step = this.task.getCurrentStep();
            this.executeStep(step, this.task.getContext());
            if (step.getState() == StepExecutionState.FAILED || step.getState() == StepExecutionState.PAUSED) {
                return false;
            }
            if (!this.nextStep()) break;
            if (!this.stopRequested) continue;
            return false;
        }
        return true;
    }

    private boolean nextStep() {
        boolean hasNextStep = this.task.recordNextStep();
        if (hasNextStep) {
            this.executionContext = this.task.getCurrentStep().getContext(this.context);
        }
        return hasNextStep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void executeStep(TaskStep step, TaskExecutionContext taskContext) {
        implementation = step.getImplementation();
        Preconditions.checkState((boolean)(step.getState() != StepExecutionState.EXECUTING), (String)"The step [%s] is still executing, cannot run again.", (Object[])new Object[]{step});
        MDC.put((String)"stepDescription", (String)implementation.getDescription());
        try {
            if (step.getState().isFinal()) {
                TaskRunner.logger.debug("Will not execute: {} with description: {} because it has state: {}", new Object[]{implementation, implementation.getDescription(), step.getState()});
                return;
            }
            step.recordStart();
            if (step.isMarkedForSkip()) {
                this.setStepState(step, StepExecutionState.SKIPPED);
                step.recordCompletion();
                return;
            }
            this.setStepState(step, StepExecutionState.EXECUTING);
            step.clearLog();
            TaskRunner.logger.info("Started {}", (Object)this);
            try {
                result = implementation.execute(this.executionContext);
                switch (1.$SwitchMap$com$xebialabs$deployit$plugin$api$flow$StepExitCode[result.ordinal()]) {
                    case 1: {
                        this.setStepState(step, StepExecutionState.DONE);
                        ** break;
lbl22:
                        // 1 sources

                        break;
                    }
                    case 2: {
                        this.setStepState(step, StepExecutionState.FAILED);
                        ** break;
lbl26:
                        // 1 sources

                        break;
                    }
                    case 3: {
                        this.setStepState(step, StepExecutionState.PAUSED);
                        break;
                    }
                    ** default:
lbl31:
                    // 1 sources

                    break;
                }
            }
            catch (Exception exc) {
                this.executionContext.logError("Step failed", (Throwable)exc);
                this.setStepState(step, StepExecutionState.FAILED);
            }
            catch (Throwable t) {
                this.executionContext.logError("Step failed badly, aborting!", t);
                Thread.currentThread().interrupt();
                this.setStepState(step, StepExecutionState.FAILED);
            }
            finally {
                TaskStep.logger.info(step.getState().name());
            }
            step.recordCompletion();
        }
        finally {
            MDC.remove((String)"stepDescription");
        }
    }

    private void setTaskState(TaskExecutionState newState) {
        TaskEvent e = TaskEvent.taskEvent(this.task, newState);
        this.task.setState(newState);
        try {
            this.context.publish(e, (EventHandlerStrategy)new ThrowingEventHandlerStrategy());
        }
        catch (BusException be) {
            if (!this.stopRequested) {
                this.stop();
                this.setTaskState(TaskExecutionState.STOPPED);
            }
            throw be;
        }
    }

    private void setStepState(TaskStep step, StepExecutionState newState) {
        StepEvent e = new StepEvent(step.getState(), newState, (TaskState)this.task, step);
        step.setState(newState);
        try {
            this.context.publish(e, (EventHandlerStrategy)new ThrowingEventHandlerStrategy());
        }
        catch (BusException be) {
            if (!this.stopRequested) {
                this.stop();
                this.setTaskState(TaskExecutionState.STOPPED);
            }
            throw be;
        }
    }

    private boolean hasMoreSteps() {
        return this.task.getNrSteps() >= this.task.getCurrentStepNr();
    }

    private boolean isAborted() {
        return this.threadHandle.isCancelled() || Thread.currentThread().isInterrupted();
    }

    private boolean isReadyForExecution() {
        return this.task.getState() == TaskExecutionState.QUEUED;
    }

    boolean isExecuting() {
        return this.task.getState() == TaskExecutionState.EXECUTING;
    }

    private boolean canBeQueued() {
        return this.task.getState() == TaskExecutionState.PENDING || this.task.getState() == TaskExecutionState.STOPPED;
    }

    FutureTask<Object> getThreadHandle() {
        return this.threadHandle;
    }

    public String toString() {
        return this.task.toString();
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$com$xebialabs$deployit$plugin$api$flow$StepExitCode;

        static {
            $SwitchMap$com$xebialabs$deployit$plugin$api$flow$StepExitCode = new int[StepExitCode.values().length];
            try {
                1.$SwitchMap$com$xebialabs$deployit$plugin$api$flow$StepExitCode[StepExitCode.SUCCESS.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$xebialabs$deployit$plugin$api$flow$StepExitCode[StepExitCode.FAIL.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$xebialabs$deployit$plugin$api$flow$StepExitCode[StepExitCode.PAUSE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

