/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.engine.tasker;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.engine.spi.execution.ExecutionStateListener;
import com.xebialabs.deployit.engine.tasker.TaskInspectionContext;
import com.xebialabs.deployit.engine.tasker.TaskStep;
import java.io.File;
import java.util.List;
import java.util.Map;

public class TaskSpecification {
    private final String description;
    private final String owner;
    private final List<TaskStep> steps;
    private final Map<String, String> metadata = Maps.newHashMap();
    private final List<ExecutionStateListener> listeners = Lists.newArrayList();
    private final File tempWorkDir;
    private TaskInspectionContext inspectionContext;

    public TaskSpecification(String description, String owner, List<TaskStep> steps) {
        this(description, owner, steps, null, null);
    }

    public TaskSpecification(String description, String owner, List<TaskStep> steps, TaskInspectionContext inspectionContext) {
        this(description, owner, steps, inspectionContext, null);
    }

    public TaskSpecification(String description, String owner, List<TaskStep> steps, TaskInspectionContext inspectionContext, File tempWorkDir) {
        this.description = description;
        this.owner = owner;
        this.steps = steps;
        this.inspectionContext = inspectionContext;
        this.tempWorkDir = tempWorkDir;
    }

    public String getDescription() {
        return this.description;
    }

    public List<TaskStep> getSteps() {
        return this.steps;
    }

    public String getOwner() {
        return this.owner;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public List<ExecutionStateListener> getListeners() {
        return this.listeners;
    }

    public TaskInspectionContext getInspectionContext() {
        return this.inspectionContext;
    }

    public File getTempWorkDir() {
        return this.tempWorkDir;
    }
}

