package com.xebialabs.deployit.test.support;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;

import static com.google.common.collect.Lists.newArrayList;

public class CapturingExecutionContext extends TestExecutionContext {

    protected List<String> capturedOutput = newArrayList();
    protected List<String> capturedError = newArrayList();

    public CapturingExecutionContext() {
    }

    public CapturingExecutionContext(Class<?> clazz) {
        super(clazz);
    }

    @Override
    public void logOutput(String output) {
        super.logOutput(output);
        this.capturedOutput.add(output);
    }

    @Override
    public void logError(String error) {
        super.logError(error);
        this.capturedError.add(error);
    }

    @Override
    public void logError(String error, Throwable t) {
        super.logError(error, t);
        this.capturedError.add(error);
        if (t != null) {
            StringWriter sw = new StringWriter();
            t.printStackTrace(new PrintWriter(sw));
            this.capturedError.add(sw.toString());
        }
    }

    public List<String> getCapturedOutput() {
        return capturedOutput;
    }

    public List<String> getCapturedError() {
        return capturedError;
    }

}