package com.xebialabs.deployit.test.support;

import com.google.common.base.Joiner;
import com.google.common.io.Files;
import com.google.common.io.Resources;

import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.*;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.test.deployment.DeltaSpecifications;
import com.xebialabs.overthere.local.LocalFile;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Set;

import static com.google.common.collect.Sets.newHashSet;

public class TestUtils {

    @SuppressWarnings("unchecked")
    public static <T extends ConfigurationItem> T newInstance(String type) {
        Descriptor descriptor = DescriptorRegistry.getDescriptor(type);
        if (descriptor == null) {
            throw new RuntimeException("Cannot instantiate unknown type");

        }
        return (T) descriptor.newInstance();
    }

    @SuppressWarnings("unchecked")
    public static <T extends ConfigurationItem> T newInstance(Class<T> clazz) {
        return (T) newInstance(Type.valueOf(clazz).toString());
    }

    public static <T extends ConfigurationItem> T newInstance(Class<T> clazz, String id) {
        T t  = (T) newInstance(Type.valueOf(clazz).toString());
        t.setId(id);
        return t;
    }

    public static String id(String... names) {
        return Joiner.on('/').join(names);
    }

    public static DeploymentPackage createDeploymentPackage(Deployable... deployables) {
        return createDeploymentPackage("1.0", deployables);
    }

    public static DeploymentPackage createDeploymentPackage(String version, Deployable... deployables) {
        Application app = newInstance(Application.class);
        app.setId(id("Applications", "Test"));
        DeploymentPackage pkg = newInstance(DeploymentPackage.class);
        pkg.setId(id(pkg.getId(), version));
        pkg.setApplication(app);

        for (Deployable deployable : deployables) {
            deployable.setId(id(app.getId(), deployable.getId()));
            pkg.addDeployable(deployable);
        }

        return pkg;
    }

    public static Environment createEnvironment(Container... containers) {
        Environment env = newInstance(Environment.class);
        env.setId(id("Environments", "JUnit"));
        Set<Container> containerSet = newHashSet();
        containerSet.addAll(Arrays.asList(containers));
        env.setMembers(containerSet);
        return env;
    }

    public static DeployedApplication createDeployedApplication(DeploymentPackage pkg, Environment env) {
        return DeltaSpecifications.createDeployedApplication(pkg, env);
    }

    public static <T extends SourceArtifact> T createArtifact(String name, String version, String classpathResource, String type, File workingFolder)
            throws IOException {
        @SuppressWarnings("unchecked")
        T artifact = (T) newInstance(type);
        artifact.setId(id("Applications", "Test", version, name));
        URL artifactURL = Thread.currentThread().getContextClassLoader().getResource(classpathResource);
        File artifactFile = new File(workingFolder, artifact.getName());
        artifactFile.createNewFile();
        Files.copy(Resources.newInputStreamSupplier(artifactURL), artifactFile);
        artifact.setFile(LocalFile.valueOf(artifactFile));
        return artifact;
    }

    public static <T extends SourceArtifact> T createArtifactWithoutCopy(String name, String version, String classpathResource, String type, File workingFolder)
            throws URISyntaxException {
        @SuppressWarnings("unchecked")
        T artifact = (T) newInstance(type);
        artifact.setId(id("Applications", "Test", version, name));
        URL artifactURL = Thread.currentThread().getContextClassLoader().getResource(classpathResource);
        artifact.setFile(LocalFile.valueOf(new File(artifactURL.toURI().getPath())));
        return artifact;
    }
}
