package com.xebialabs.deployit.test.deployment;

import java.util.List;

import com.xebialabs.deployit.deployment.planner.StepPlan;
import com.xebialabs.deployit.deployment.planner.Plan;
import com.xebialabs.deployit.deployment.planner.SerialPlan;

import static com.google.common.collect.Lists.newArrayList;

public class PlanUtils {

    public static List<StepPlan.StepWithDelta> flattenPlan(Plan serialPlan) {
        List<StepPlan.StepWithDelta> stepsWithDelta = newArrayList();
        for (Plan plan : ((SerialPlan)serialPlan).getSubPlans()) {
            if (plan instanceof StepPlan)  {
                stepsWithDelta.addAll(((StepPlan)plan).getStepsWithDelta());
            } else if(plan instanceof SerialPlan) {
                stepsWithDelta.addAll(flattenPlan(plan));
            } else {
                throw new RuntimeException("Can not flatten " + plan.getClass().getSimpleName());
            }

        }

        return stepsWithDelta;
    }

    public static List<StepPlan.Checkpoint> resolveCheckpoints(Plan plan){
        List<StepPlan.Checkpoint> checkpoints = newArrayList();
        if (plan instanceof SerialPlan)  {
            for (Plan subPlan : ((SerialPlan)plan).getSubPlans()) {
                checkpoints.addAll(resolveCheckpoints(subPlan));
            }
        } else if (plan instanceof StepPlan)  {
            checkpoints.addAll(((StepPlan) plan).getCheckpoints());
        } else {
            throw new RuntimeException("Can not flatten " + plan.getClass().getSimpleName());
        }
        return checkpoints;
    }
}
