package com.xebialabs.deployit.test.support;

import com.xebialabs.deployit.plugin.api.flow.ITask;
import com.xebialabs.deployit.plugin.api.services.Repository;
import com.xebialabs.deployit.test.repository.InMemoryRepository;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;

import static com.google.common.collect.Lists.newArrayList;

public class CapturingExecutionContext extends TestExecutionContext {

    protected List<String> capturedOutput = newArrayList();
    protected List<String> capturedError = newArrayList();
    protected ITask task;


    public CapturingExecutionContext() {
        super(InMemoryRepository.REFERENCE.get());
    }

    public CapturingExecutionContext(Class<?> clazz) {
        super(clazz, InMemoryRepository.REFERENCE.get());
    }

    public CapturingExecutionContext(Repository repository) {
        super(repository);
    }

    public CapturingExecutionContext(final String taskid, Class<?> repository) {
        super(repository);
        this.task = new ITask() {
            @Override
            public String getId() {
                return taskid;
            }

            @Override
            public String getUsername() {
                return null;
            }

            @Override
            public Map<String, String> getMetadata() {
                return null;
            }
        };
    }

    @Override
    public void logOutput(String output) {
        super.logOutput(output);
        this.capturedOutput.add(output);
    }

    @Override
    public void logError(String error) {
        super.logError(error);
        this.capturedError.add(error);
    }

    @Override
    public void logError(String error, Throwable t) {
        super.logError(error, t);
        this.capturedError.add(error);
        if (t != null) {
            StringWriter sw = new StringWriter();
            t.printStackTrace(new PrintWriter(sw));
            this.capturedError.add(sw.toString());
        }
    }

    @Override
    public ITask getTask() {
        return task;
    }

    public List<String> getCapturedOutput() {
        return capturedOutput;
    }


    public List<String> getCapturedError() {
        return capturedError;
    }
}
