/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.test.repository;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.services.Repository;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.platform.test.TestUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

public class InMemoryRepository
implements Repository {
    public static final AtomicReference<InMemoryRepository> REFERENCE = new AtomicReference<InMemoryRepository>(new InMemoryRepository());
    private Map<String, ConfigurationItem> store = new HashMap<String, ConfigurationItem>();

    public void initializeWithFakeRootFolders() {
        this.create(new ConfigurationItem[]{TestUtils.newInstance("test.Root", "Configuration")});
        this.create(new ConfigurationItem[]{TestUtils.newInstance("test.Root", "Infrastructure")});
        this.create(new ConfigurationItem[]{TestUtils.newInstance("test.Root", "Applications")});
        this.create(new ConfigurationItem[]{TestUtils.newInstance("test.Root", "Environments")});
    }

    public boolean exists(String id) {
        return this.store.containsKey(id);
    }

    public <T extends ConfigurationItem> T read(String id) {
        if (!this.exists(id)) {
            throw new IllegalArgumentException("Repository does not contain item with id " + id);
        }
        return (T)this.store.get(id);
    }

    public <T extends ConfigurationItem> List<T> read(List<String> ids, Integer depth) {
        return ids.stream().map(this::read).collect(Collectors.toList());
    }

    @SafeVarargs
    public final <T extends ConfigurationItem> void create(T ... entities) {
        this.checkThatEntitiesDoNotExist((ConfigurationItem[])entities);
        this.storeEntities((ConfigurationItem[])entities);
    }

    @SafeVarargs
    public final <T extends ConfigurationItem> void update(T ... entities) {
        this.storeEntities((ConfigurationItem[])entities);
    }

    @SafeVarargs
    public final <T extends ConfigurationItem> void createOrUpdate(T ... entities) {
        this.storeEntities((ConfigurationItem[])entities);
    }

    public void delete(String ... ids) {
        for (String id : ids) {
            this.store.remove(id);
        }
    }

    public void move(String id, String newId) {
        ConfigurationItem ci = this.store.remove(id);
        ci.setId(newId);
        this.store.put(newId, ci);
    }

    public void rename(String id, String newName) {
        int i = id.lastIndexOf("/");
        Object newId = newName;
        if (i > -1) {
            newId = id.substring(0, i + 1) + newName;
        }
        this.move(id, (String)newId);
    }

    public <T extends ConfigurationItem> List<T> search(Type type) {
        ArrayList<ConfigurationItem> entities = new ArrayList<ConfigurationItem>();
        for (ConfigurationItem configurationItem : this.store.values()) {
            if (type != null && !configurationItem.getType().instanceOf(type)) continue;
            entities.add(configurationItem);
        }
        return entities;
    }

    public <T extends ConfigurationItem> List<T> search(Type type, String parent) {
        List<T> search = this.search(type);
        return search.stream().filter(ci -> ci.getId().startsWith(parent)).collect(Collectors.toList());
    }

    private void checkThatEntitiesDoNotExist(ConfigurationItem[] entities) {
        for (ConfigurationItem entity : entities) {
            if (!this.store.containsKey(entity.getId())) continue;
            throw new IllegalStateException("Entity " + entity.getId() + " already exists and cannot be created twice.");
        }
    }

    private void storeEntities(ConfigurationItem[] entities) {
        for (ConfigurationItem entity : entities) {
            this.store.put(entity.getId(), entity);
        }
    }

    public void clear() {
        this.store.clear();
    }
}

