package com.xebialabs.platform.test.testng;

import java.util.Map;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.sift.Discriminator;

/**
 * Interacts with test setup code that sets a MDC ProvisionedVm to the VM being provisioned. And for TestNG add the
 * MdcTestListener to a test case to set the test name in the MDC. Use as follows:
 *
 * <pre>
 *     &lt;appender name=&quot;SIFT&quot; class=&quot;ch.qos.logback.classic.sift.SiftingAppender&quot;&gt;
 *       &lt;discriminator class=&quot;com.xebialabs.probsels.CombinedMdcDiscriminator&quot; /&gt;
 *       &lt;sift&gt;
 *          &lt;appender name=&quot;${logname}&quot; class=&quot;ch.qos.logback.core.FileAppender&quot;&gt;
 *               &lt;file&gt;${logname}.log&lt;/file&gt;
 *               &lt;layout class=&quot;ch.qos.logback.classic.PatternLayout&quot;&gt;
 *                   &lt;pattern&gt;%d{yyyy-MM-dd HH:mm:ss.SSS} [%thread] {%mdc} %-5level %logger{36} - %msg%n%rootException&lt;/pattern&gt;
 *               &lt;/layout&gt;
 *           &lt;/appender&gt;
 *       &lt;/sift&gt;
 *   &lt;/appender&gt;
 * </pre>
 */
public class CombinedMdcDiscriminator implements Discriminator<ILoggingEvent> {
    private static final String KEY = "logname";
    private boolean started;

    @Override
    public String getDiscriminatingValue(ILoggingEvent iLoggingEvent) {
        Map<String, String> mdc = iLoggingEvent.getMDCPropertyMap();
        String vm = mdc.get("ProvisionedVm");
        if (vm != null) {
            return "provision-" + vm;
        }
        String test = mdc.get(MdcTestListener.MDC_KEY_LOG);
        if (test != null) {
            return "test-" + test;
        }
        return "log";
    }

    @Override
    public String getKey() {
        return KEY;
    }

    public void start() {
        started = true;
    }

    public void stop() {
        started = false;
    }

    public boolean isStarted() {
        return started;
    }
}