/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.test.repository;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.services.Repository;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class InMemoryRepository
implements Repository {
    public static final AtomicReference<InMemoryRepository> REFERENCE = new AtomicReference<InMemoryRepository>(new InMemoryRepository());
    private Map<String, ConfigurationItem> store = Maps.newHashMap();

    public boolean exists(String id) {
        return this.store.containsKey(id);
    }

    public <T extends ConfigurationItem> T read(String id) {
        return (T)this.store.get(id);
    }

    public <T extends ConfigurationItem> void create(T ... entities) {
        this.checkThatEntitiesDoNotExist((ConfigurationItem[])entities);
        this.storeEntities((ConfigurationItem[])entities);
    }

    public <T extends ConfigurationItem> void update(T ... entities) {
        this.storeEntities((ConfigurationItem[])entities);
    }

    public <T extends ConfigurationItem> void createOrUpdate(T ... entities) {
        this.storeEntities((ConfigurationItem[])entities);
    }

    public void delete(String ... ids) {
        for (String id : ids) {
            this.store.remove(id);
        }
    }

    public void move(String id, String newId) {
        ConfigurationItem ci = this.store.remove(id);
        ci.setId(newId);
        this.store.put(newId, ci);
    }

    public void rename(String id, String newName) {
        int i = id.lastIndexOf("/");
        String newId = newName;
        if (i > -1) {
            newId = id.substring(0, i + 1) + newName;
        }
        this.move(id, newId);
    }

    public <T extends ConfigurationItem> List<T> search(Type type) {
        ArrayList entities = Lists.newArrayList();
        for (ConfigurationItem configurationItem : this.store.values()) {
            if (!configurationItem.getType().equals((Object)type)) continue;
            entities.add(configurationItem);
        }
        return entities;
    }

    public <T extends ConfigurationItem> List<T> search(Type type, final String parent) {
        return Lists.newArrayList((Iterable)Iterables.filter(this.search(type), (Predicate)new Predicate<ConfigurationItem>(){

            public boolean apply(ConfigurationItem input) {
                return input.getId().startsWith(parent);
            }
        }));
    }

    private void checkThatEntitiesDoNotExist(ConfigurationItem[] entities) {
        for (ConfigurationItem entity : entities) {
            if (!this.store.containsKey(entity.getId())) continue;
            throw new IllegalStateException("Entity " + entity.getId() + " already exists and cannot be created twice.");
        }
    }

    private void storeEntities(ConfigurationItem[] entities) {
        for (ConfigurationItem entity : entities) {
            this.store.put(entity.getId(), entity);
        }
    }

    public void clear() {
        this.store.clear();
    }
}

