/*
 * Copyright (c) 2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of Xebialabs Software and Documentation is subject to the Personal
 * License Agreement.
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * ‚ÄúDocumentation‚Äù means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the Xebialabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to  (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.jbossas.ci;

import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ConfigurationItemProperty.Size;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.ci.artifact.mapping.EarMapping;
import com.xebialabs.deployit.hostsession.HostSession;

/**
 * A JBoss Application Server
 */
@SuppressWarnings("serial")
@ConfigurationItem(description = "JBoss Application Server instance", targetForMappingTypes = { EarMapping.class })
public class JbossasServer extends BaseConfigurationItem {

	@ConfigurationItemProperty(required = true, label = "JBoss server host", description = "The host on which the JBoss server is running")
	private Host host;

	@ConfigurationItemProperty(required = true, label = "JBoss installation location", description = "The place where JBoss is installed such as /usr/local/jboss-5.1.0.GA", size = Size.LARGE)
	private String home;

	@ConfigurationItemProperty(required = true, label = "JBoss instance name", description = "The name of the JBoss server instance, e.g. default or minimal")
	private String name;

	public String getCommandFilePath(String command) {
		String fileSep = getHost().getFileSeparator();
		return getHome() + fileSep + "bin" + fileSep + command + getHost().getScriptExtension();
	}

	public String getTwiddleFilePath() {
		return getCommandFilePath("twiddle");
	}

	public String getShutdownFilePath() {
		return getCommandFilePath("shutdown");
	}

	public String getDeployDirPath() {
		String fileSep = getHost().getFileSeparator();
		return getHome() + fileSep + "server" + fileSep + getName() + fileSep + "deploy";
	}

	public HostSession connectToAdminHost() {
		return getHost().getHostSession();
	}

	public Host getHost() {
		return host;
	}

	public void setHost(Host host) {
		this.host = host;
	}

	public String getHome() {
		return home;
	}

	public void setHome(String home) {
		this.home = home;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

}
