/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.jbossas.ci;

import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.ci.artifact.mapping.EarMapping;
import com.xebialabs.deployit.hostsession.HostSession;

@ConfigurationItem(description="JBoss Application Server instance", targetForMappingTypes={EarMapping.class})
public class JbossasServer
extends BaseConfigurationItem {
    @ConfigurationItemProperty(required=true, label="JBoss server host", description="The host on which the JBoss server is running")
    private Host host;
    @ConfigurationItemProperty(required=true, label="JBoss installation location", description="The place where JBoss is installed such as /usr/local/jboss-5.1.0.GA", size=ConfigurationItemProperty.Size.LARGE)
    private String home;
    @ConfigurationItemProperty(required=true, label="JBoss instance name", description="The name of the JBoss server instance, e.g. default or minimal")
    private String name;

    public String getCommandFilePath(String command) {
        String fileSep = this.getHost().getFileSeparator();
        return this.getHome() + fileSep + "bin" + fileSep + command + this.getHost().getScriptExtension();
    }

    public String getTwiddleFilePath() {
        return this.getCommandFilePath("twiddle");
    }

    public String getShutdownFilePath() {
        return this.getCommandFilePath("shutdown");
    }

    public String getDeployDirPath() {
        String fileSep = this.getHost().getFileSeparator();
        return this.getHome() + fileSep + "server" + fileSep + this.getName() + fileSep + "deploy";
    }

    public HostSession connectToAdminHost() {
        return this.getHost().getHostSession();
    }

    public Host getHost() {
        return this.host;
    }

    public void setHost(Host host) {
        this.host = host;
    }

    public String getHome() {
        return this.home;
    }

    public void setHome(String home) {
        this.home = home;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

