/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.jbossas.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostFileUtils;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasServer;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasTopic;
import com.xebialabs.deployit.plugin.jbossas.step.JbossasStepBase;
import com.xebialabs.deployit.plugin.jbossas.support.VelocityUtils;
import org.apache.velocity.VelocityContext;

public class CreateJbossasTopicStep
extends JbossasStepBase {
    private JbossasTopic topic;

    public CreateJbossasTopicStep(JbossasServer server, JbossasTopic topic) {
        super(server);
        this.topic = topic;
        this.setDescription("Create topic " + (Object)((Object)topic) + " on JBoss server " + (Object)((Object)server));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(StepExecutionContext ctx) {
        VelocityContext context = new VelocityContext();
        context.put("topic", (Object)this.topic);
        String evaluatedTemplate = VelocityUtils.evaluateTemplate(context, "com/xebialabs/deployit/plugin/jbossas/step/template-topic-service.xml.vm");
        HostSession s = this.server.connectToAdminHost();
        try {
            HostFile deployDir = s.getFile(this.server.getDeployDirPath());
            HostFile topicServiceFile = s.getFile(deployDir, this.topic.getFilename());
            ctx.logOutput("Copying topic configuration to " + topicServiceFile.getPath() + " on " + this.server.getHost());
            HostFileUtils.putStringToHostFile((String)evaluatedTemplate, (HostFile)topicServiceFile);
            ctx.logOutput("Done.");
            boolean bl = true;
            return bl;
        }
        finally {
            s.close();
        }
    }
}

